/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;

public class TMappingExclusionConfig {
    private final ImmutableSet<String> classes;
    private final ImmutableSet<String> properties;

    public TMappingExclusionConfig(ImmutableSet<String> classes, ImmutableSet<String> properties) {
        this.classes = classes;
        this.properties = properties;
    }

    public boolean contains(OClass cls) {
        return this.classes.contains((Object)cls.getIRI().getIRIString());
    }

    public boolean contains(ObjectPropertyExpression propertyExpression) {
        return !propertyExpression.isInverse() && this.properties.contains((Object)propertyExpression.getIRI().getIRIString());
    }

    public boolean contains(DataPropertyExpression propertyExpression) {
        return this.properties.contains((Object)propertyExpression.getIRI().getIRIString());
    }

    public static TMappingExclusionConfig empty() {
        return new TMappingExclusionConfig((ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TMappingExclusionConfig parseFile(String fileName) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        HashSet<String> properties = new HashSet<String>();
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            String s;
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).isEmpty() || s.startsWith("#")) continue;
                String[] s2 = s.split(" ");
                if (s2.length != 2) {
                    throw new IllegalArgumentException("cannot parse line (too many columns): " + s);
                }
                try {
                    int arity = Integer.parseInt(s2[1]);
                    switch (arity) {
                        case 1: {
                            classes.add(s2[0]);
                            break;
                        }
                        case 2: {
                            properties.add(s2[0]);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("cannot parse line (wrong arity): " + s);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("cannot parse line (wrong arity): " + s);
                    return new TMappingExclusionConfig((ImmutableSet<String>)ImmutableSet.copyOf(classes), (ImmutableSet<String>)ImmutableSet.copyOf(properties));
                }
            }
        }
    }
}

