/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.substitution.Substitution;
import java.util.Optional;

public class MappingAssertion {
    private final MappingAssertionIndex index;
    private final IQ query;
    private final PPMappingAssertionProvenance provenance;

    public MappingAssertion(IQ query, PPMappingAssertionProvenance provenance) {
        this.query = query;
        this.provenance = provenance;
        RDFAtomPredicate rdfAtomPredicate = Optional.of(query.getProjectionAtom().getPredicate()).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).orElseThrow(() -> new MinorOntopInternalBugException("The mapping assertion does not have an RDFAtomPredicate"));
        ImmutableList<ImmutableTerm> terms = this.getTerms();
        Optional propertyIRI = rdfAtomPredicate.getPropertyIRI(terms);
        this.index = propertyIRI.filter(iri -> iri.equals((Object)RDF.TYPE)).isPresent() ? MappingAssertionIndex.ofClass(rdfAtomPredicate, rdfAtomPredicate.getClassIRI(terms)) : MappingAssertionIndex.ofProperty(rdfAtomPredicate, propertyIRI);
    }

    public IQ getQuery() {
        return this.query;
    }

    public PPMappingAssertionProvenance getProvenance() {
        return this.provenance;
    }

    public MappingAssertion copyOf(IQ query) {
        return new MappingAssertion(query, this.provenance);
    }

    public MappingAssertion copyOf(IQTree tree, IntermediateQueryFactory iqFactory) {
        return new MappingAssertion(iqFactory.createIQ(this.query.getProjectionAtom(), tree), this.provenance);
    }

    public ImmutableSet<Variable> getProjectedVariables() {
        return this.query.getTree().getVariables();
    }

    public RDFAtomPredicate getRDFAtomPredicate() {
        return this.index.getPredicate();
    }

    public ImmutableList<ImmutableTerm> getTerms() {
        return this.getTopSubstitution().apply(this.getProjectionAtom().getArguments());
    }

    public Substitution<ImmutableTerm> getTopSubstitution() {
        return Optional.of(this.query.getTree()).map(IQTree::getRootNode).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(ConstructionNode::getSubstitution).orElseThrow(() -> new MinorOntopInternalBugException("The mapping assertion was expecting to start with a construction node\n" + this.query));
    }

    public IQTree getTopChild() {
        return ((UnaryIQTree)this.query.getTree()).getChild();
    }

    public DistinctVariableOnlyDataAtom getProjectionAtom() {
        return this.query.getProjectionAtom();
    }

    public MappingAssertionIndex getIndex() {
        return this.index;
    }

    public String toString() {
        return this.query.toString();
    }

    public static class NoGroundPredicateOntopInternalBugException
    extends OntopInternalBugException {
        protected NoGroundPredicateOntopInternalBugException(String message) {
            super(message);
        }
    }
}

