/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.impl.OntopKGQuerySettingsImpl;
import it.unibz.inf.ontop.spec.fact.FactExtractor;
import java.util.Map;
import java.util.Properties;

class OntopMappingSettingsImpl
extends OntopKGQuerySettingsImpl
implements OntopMappingSettings {
    private static final String DEFAULT_FILE = "mapping-default.properties";

    OntopMappingSettingsImpl(Properties properties) {
        super(OntopMappingSettingsImpl.loadProperties(properties));
    }

    private static Properties loadProperties(Properties userProperties) {
        Properties properties = OntopMappingSettingsImpl.loadDefaultMappingProperties();
        properties.putAll((Map<?, ?>)userProperties);
        String factExtractorKey = FactExtractor.class.getCanonicalName();
        if (!userProperties.containsKey(factExtractorKey)) {
            String factExtractorValue;
            Boolean withTBoxFactExtractor = (Boolean)OntopMappingSettingsImpl.getBoolean((Properties)properties, (String)"ontop.enableFactExtractionWithTBox").orElseThrow(() -> new InvalidOntopConfigurationException("ontop.enableFactExtractionWithTBoxis required but missing (must have a default value)"));
            String string = factExtractorValue = withTBoxFactExtractor != false ? properties.getProperty("fact-extraction-with-tbox") : properties.getProperty("fact-extraction-without-tbox");
            if (factExtractorValue == null) {
                throw new InvalidOntopConfigurationException("Missing a default value for using the fact extractor");
            }
            properties.put(factExtractorKey, factExtractorValue);
        }
        return properties;
    }

    static Properties loadDefaultMappingProperties() {
        return OntopMappingSettingsImpl.loadDefaultPropertiesFromFile(OntopMappingSettings.class, (String)DEFAULT_FILE);
    }

    @Override
    public boolean isDefaultDatatypeInferred() {
        return this.getRequiredBoolean("ontop.inferDefaultDatatype");
    }

    @Override
    public boolean areAbstractDatatypesToleratedInMapping() {
        return this.getRequiredBoolean("ontop.tolerateAbstractDatatype");
    }

    @Override
    public boolean isOntologyAnnotationQueryingEnabled() {
        return this.getRequiredBoolean("ontop.queryOntologyAnnotation");
    }

    @Override
    public boolean isCanIRIComplete() {
        return this.getRequiredBoolean("ontop.isCanonicalIRIComplete");
    }

    @Override
    public boolean isFactExtractionWithTBoxEnabled() {
        return this.getRequiredBoolean("ontop.enableFactExtractionWithTBox");
    }

    @Override
    public boolean areSuperClassesOfDomainRangeInferred() {
        return this.getRequiredBoolean("ontop.querySuperClassesOfDomainRange");
    }

    @Override
    public boolean isValuesNodesWrapInLensesInMappingEnabled() {
        return this.getRequiredBoolean("ontop.wrapMappingValuesNodesInLenses");
    }
}

