/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.service;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.ontotext.forest.graphexplore.model.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.stereotype.Service;

@Service
public class DomainRangeGraphService {
    private static final int CIRCLE_RADIUS = 500;
    private static final String RIGHT_OBJECT_NODE_PROP_TYPE = "objectRight";
    private static final String LEFT_OBJECT_NODE_PROP_TYPE = "objectLeft";
    private static final String LEFT_RIGHT_OBJECT_NODE_PROP_TYPE = "objectLeftRight";
    private static final String DATATYPE_NODE_PROP_TYPE = "datatype";
    private static final String RIGHT_CLASS_POSITION = "right";
    private static final String LEFT_CLASS_POSITION = "left";
    private static final String MAIN_CLASS_POSITION = "main";

    public Graph constructPropertiesGraph(Map<String, List<String>> rawResults, Map<String, List<String>> resolvedResults, String targetUri) {
        ArrayList nodes = Lists.newArrayList();
        Graph.Node mainNode = new Graph.Node(0.0, 0.0, null, null, MAIN_CLASS_POSITION);
        nodes.add(mainNode);
        ArrayList edges = Lists.newArrayList();
        List<String> propertyUris = rawResults.get("prop");
        List<String> properties = resolvedResults.get("prop");
        if (properties == null || propertyUris == null) {
            return new Graph(new ArrayList<Graph.Node>(), new ArrayList<Graph.Edge>());
        }
        List<String> propertyTypes = resolvedResults.get("propertyType");
        List<String> objectPropClassNames = resolvedResults.get("objectPropClass");
        List<String> objectPropClassUris = rawResults.get("objectPropClass");
        List<String> implicit = rawResults.get("implicit");
        int numberOfPoints = properties.size();
        double slice = Math.PI / (double)numberOfPoints;
        int objectPropClassIdx = 0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double angle = slice * (double)i + 1.0;
            String propName = properties.get(i);
            String propUri = propertyUris.get(i);
            String currentPropType = propertyTypes.get(i);
            String objectPropClassName = null;
            String objectPropClassUri = null;
            if (!currentPropType.equals(DATATYPE_NODE_PROP_TYPE)) {
                objectPropClassName = objectPropClassNames.get(objectPropClassIdx);
                objectPropClassUri = objectPropClassUris.get(objectPropClassIdx);
                if (objectPropClassIdx < objectPropClassNames.size() - 1) {
                    ++objectPropClassIdx;
                }
            }
            double newX = 500.0 * Math.cos(angle);
            double newY = 500.0 * Math.sin(angle);
            Graph.Node node = null;
            Graph.Edge edge = null;
            boolean isImplicit = Boolean.parseBoolean(implicit.get(i));
            switch (currentPropType) {
                case "objectLeftRight": 
                case "objectRight": 
                case "datatype": {
                    node = new Graph.Node(-newX, -newY, objectPropClassName, objectPropClassUri, RIGHT_CLASS_POSITION);
                    edge = new Graph.Edge(propName, propUri, currentPropType, isImplicit, 0, i + 1, node);
                    break;
                }
                case "objectLeft": {
                    node = new Graph.Node(newX, newY, objectPropClassName, objectPropClassUri, LEFT_CLASS_POSITION);
                    edge = new Graph.Edge(propName, propUri, currentPropType, isImplicit, i + 1, 0, node);
                }
            }
            nodes.add(node);
            edges.add(edge);
        }
        return new Graph(nodes, edges);
    }

    public Graph constructCollapsedPropertiesGraph(Map<String, List<String>> rawResults, Map<String, List<String>> resolvedResults, String targetUri) {
        Set<Graph.Node> nodes = this.initNodesSet();
        Set<Graph.Edge> edges = this.initDomainRangeEdgesSet();
        Graph.Node mainNode = new Graph.Node(0.0, 0.0, null, null, MAIN_CLASS_POSITION);
        ArrayListMultimap nodeEdgesMap = ArrayListMultimap.create();
        List<String> propertyUris = rawResults.get("prop");
        List<String> properties = resolvedResults.get("prop");
        if (properties == null || propertyUris == null) {
            return new Graph(new TreeSet<Graph.Node>(), new TreeSet<Graph.Edge>());
        }
        List<String> propertyTypes = resolvedResults.get("propertyType");
        List<String> objectPropClassNames = resolvedResults.get("objectPropClass");
        List<String> objectPropClassUris = rawResults.get("objectPropClass");
        List<String> implicit = rawResults.get("implicit");
        int numberOfPoints = properties.size();
        double slice = Math.PI / (double)numberOfPoints;
        int objectPropClassIdx = 0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double angle = slice * (double)i + 1.0;
            String propName = properties.get(i);
            String propUri = propertyUris.get(i);
            String currentPropType = propertyTypes.get(i);
            String objectPropClassName = null;
            String objectPropClassUri = null;
            if (!currentPropType.equals(DATATYPE_NODE_PROP_TYPE)) {
                objectPropClassName = objectPropClassNames.get(objectPropClassIdx);
                objectPropClassUri = objectPropClassUris.get(objectPropClassIdx);
                if (objectPropClassIdx < objectPropClassNames.size() - 1) {
                    ++objectPropClassIdx;
                }
            }
            double newX = 500.0 * Math.cos(angle);
            double newY = 500.0 * Math.sin(angle);
            Graph.Node node = null;
            Graph.Edge edge = null;
            boolean isImplicit = Boolean.parseBoolean(implicit.get(i));
            switch (currentPropType) {
                case "objectLeftRight": 
                case "objectRight": {
                    node = new Graph.Node(-newX, -newY, objectPropClassName, objectPropClassUri, RIGHT_CLASS_POSITION);
                    edge = new Graph.Edge(propName, propUri, currentPropType, isImplicit, node);
                    break;
                }
                case "datatype": {
                    if (!Strings.isNullOrEmpty((String)objectPropClassName)) break;
                    node = new Graph.Node(-newX, -newY, objectPropClassName, objectPropClassUri, RIGHT_CLASS_POSITION);
                    edge = new Graph.Edge(propName, propUri, currentPropType, isImplicit, node);
                    break;
                }
                case "objectLeft": {
                    node = new Graph.Node(newX, newY, objectPropClassName, objectPropClassUri, LEFT_CLASS_POSITION);
                    edge = new Graph.Edge(propName, propUri, currentPropType, isImplicit, node);
                }
            }
            String targetNodeUri = Optional.ofNullable(edge.getNode().getObjectPropClassUri()).orElse("");
            String targetNodeClassPosition = edge.getNode().getClassPosition();
            String compositeTargetNodeKey = String.join((CharSequence)"|", targetNodeUri, targetNodeClassPosition);
            nodeEdgesMap.put((Object)compositeTargetNodeKey, (Object)edge);
            nodes.add(node);
            edges.add(edge);
        }
        nodes.add(mainNode);
        ArrayList edgesList = Lists.newArrayList(edges);
        block22: for (int i = 0; i < edgesList.size(); ++i) {
            Graph.Edge currentEdge = (Graph.Edge)edgesList.get(i);
            switch (currentEdge.getPropertyType()) {
                case "objectLeftRight": 
                case "objectRight": 
                case "datatype": {
                    currentEdge.setSource(0);
                    currentEdge.setTarget(i + 1);
                    continue block22;
                }
                case "objectLeft": {
                    currentEdge.setSource(i + 1);
                    currentEdge.setTarget(0);
                }
            }
        }
        nodes = this.setEdgesToNode(nodes, (Multimap<String, Graph.Edge>)nodeEdgesMap);
        edges = this.addEdgesCountPerNode(edges, nodes);
        return new Graph(nodes, edges);
    }

    private Set<Graph.Edge> addEdgesCountPerNode(Set<Graph.Edge> edges, Set<Graph.Node> nodes) {
        for (int targetNodeIdx = 0; targetNodeIdx < nodes.size(); ++targetNodeIdx) {
            for (Graph.Edge edge : edges) {
                Set currentNodeEdges = Optional.ofNullable(edge.getNode().getAllEdges()).orElse(new TreeSet());
                if (edge.getTarget() != targetNodeIdx) continue;
                edge.setTargetNodeEdgeCount(currentNodeEdges.size());
            }
        }
        return edges;
    }

    private Set<Graph.Node> setEdgesToNode(Set<Graph.Node> nodes, Multimap<String, Graph.Edge> nodeEdgesMap) {
        for (Graph.Node node : nodes) {
            String currentObjectPropClassUri = Optional.ofNullable(node.getObjectPropClassUri()).orElse("");
            String currentObjectClassPosition = node.getClassPosition();
            String currentObjectCompositeKey = String.join((CharSequence)"|", currentObjectPropClassUri, currentObjectClassPosition);
            nodeEdgesMap.asMap().forEach((k, v) -> {
                if (currentObjectCompositeKey.equals(k)) {
                    Set<Graph.Edge> allEdgesSet = this.initNodeAllEdgesSet();
                    allEdgesSet.addAll((Collection<Graph.Edge>)v);
                    node.setAllEdges(allEdgesSet);
                }
            });
        }
        return nodes;
    }

    private Set<Graph.Edge> initNodeAllEdgesSet() {
        return Sets.newTreeSet((e1, e2) -> e1.getUri().compareTo(e2.getUri()));
    }

    private Set<Graph.Edge> initDomainRangeEdgesSet() {
        return Sets.newTreeSet((e1, e2) -> {
            boolean haveEqualTargetNodes;
            String targetNodeUri1 = Optional.ofNullable(e1.getNode().getObjectPropClassUri()).orElse("");
            String targetNodeUri2 = Optional.ofNullable(e2.getNode().getObjectPropClassUri()).orElse("");
            String targetNodeClassPosition1 = e1.getNode().getClassPosition();
            String targetNodeClassPosition2 = e2.getNode().getClassPosition();
            boolean bl = haveEqualTargetNodes = targetNodeUri1.equals(targetNodeUri2) && targetNodeClassPosition1.equals(targetNodeClassPosition2);
            if (haveEqualTargetNodes) {
                return 0;
            }
            return -1;
        });
    }

    private Set<Graph.Node> initNodesSet() {
        return Sets.newTreeSet((n1, n2) -> {
            boolean areDatatypeNodes;
            String objectPropClassUri1 = Optional.ofNullable(n1.getObjectPropClassUri()).orElse("");
            String objectPropClassUri2 = Optional.ofNullable(n2.getObjectPropClassUri()).orElse("");
            String classPosition1 = n1.getClassPosition();
            String classPosition2 = n2.getClassPosition();
            boolean haveSameClassUrisAndSameClassPositions = !objectPropClassUri1.isEmpty() && !objectPropClassUri2.isEmpty() && objectPropClassUri1.equals(objectPropClassUri2) && classPosition1.equals(classPosition2);
            boolean bl = areDatatypeNodes = objectPropClassUri1.isEmpty() && objectPropClassUri2.isEmpty() && classPosition1.equals(RIGHT_CLASS_POSITION) && classPosition2.equals(RIGHT_CLASS_POSITION);
            if (haveSameClassUrisAndSameClassPositions || areDatatypeNodes) {
                return 0;
            }
            return -1;
        });
    }
}

