/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.service.URIPrefixService;
import com.ontotext.forest.graphexplore.model.DependencyClass;
import com.ontotext.forest.graphexplore.model.DependencyEdge;
import com.ontotext.forest.graphexplore.model.DependencyPredicate;
import com.ontotext.forest.graphexplore.model.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest/dependencies"})
@RestController
public class DependenciesController {
    private static final Logger LOG = LoggerFactory.getLogger(DependenciesController.class);
    private static final String ERROR_STATUS = "ERROR";
    private static final String IN_PROGRESS_STATUS = "IN_PROGRESS";
    private static final String DEPENDENCIES_PLUGIN_QUERY = "ASK { _:sm <http://www.ontotext.com/plugins/dependencies#present> ?o . }";
    private static final String DEPENDENCIES_STATUS_QUERY = "SELECT ?status WHERE { {{fromGraph}} ?s <http://www.ontotext.com/plugins/dependencies#status> ?status . {{closingBracket}} }";
    private static final String UPDATE_DEPENDENCIES_QUERY = "ASK { {{fromGraph}} _:sm <http://www.ontotext.com/plugins/dependencies#update> _:sm .{{closingBracket}} }";
    private static final String PLUGIN_DATA_CHANGED = "ASK { {{fromGraph}} _:sm <http://www.ontotext.com/plugins/dependencies#dataChanged> _:sm .{{closingBracket}} }";
    private static final String GET_DEPENDENCIES_QUERY = "PREFIX deps: <http://www.ontotext.com/plugins/dependencies#> SELECT * WHERE {{{fromGraph}}?a deps:dependencies _:x ._:x deps:to ?b ._:x deps:count ?c . {{closingBracket}}  } order by desc(?c)  ";
    private static final String GET_DEPENDENCIES_PREDICATES_QRY = "PREFIX deps: <http://www.ontotext.com/plugins/dependencies#> select * { {{fromGraph}}_:b deps:listPredicates '' ;         deps:fromClass {{fromClass}} ;         deps:toClass  {{toClass}} ;         deps:predicate ?p ;         deps:predicateCount ?c .          {{closingBracket}}} ";
    private final SemanticDataManagement semanticDataManagement;
    private final URIPrefixService uriPrefixService;

    @Autowired
    public DependenciesController(SemanticDataManagement semanticDataManagement, URIPrefixService uriPrefixService) {
        this.semanticDataManagement = semanticDataManagement;
        this.uriPrefixService = uriPrefixService;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"status"})
    public ResponseEntity<String> getDependenciesStatus(@RequestParam(required=false, defaultValue="") String graphURI) throws GraphDBWorkbenchException {
        if (!this.isPluginAvailable()) {
            return new ResponseEntity((Object)"N/A", (HttpStatusCode)HttpStatus.OK);
        }
        String status = this.getDependenciesPluginStatus(graphURI);
        if ("NONE".equals(status)) {
            return this.runUpdate(graphURI);
        }
        if ("READY".equals(status)) {
            Pair<List<DependencyClass>, Boolean> dependenciesPair = this.getDependencyClassList(graphURI);
            if (dependenciesPair != null) {
                return new ResponseEntity((Object)status, (HttpStatusCode)(dependenciesPair.getRight() != false ? HttpStatus.MULTI_STATUS : HttpStatus.OK));
            }
            return new ResponseEntity((Object)"ERROR;Could not calculate dependencies statistics", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
    }

    private ResponseEntity<String> runUpdate(String graphURI) throws GraphDBWorkbenchException {
        if (this.runUpdateDependencies(graphURI)) {
            return new ResponseEntity((Object)IN_PROGRESS_STATUS, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)"ERROR;Cannot get dependencies status", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"update"})
    public ResponseEntity<String> updateDependencies(@RequestParam(required=false, defaultValue="") String graphURI) throws GraphDBWorkbenchException {
        return this.runUpdate(graphURI);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"classes"})
    public ResponseEntity<List<DependencyClass>> getDependencyClasses(@RequestParam(required=false, defaultValue="all") String mode, @RequestParam(required=false, defaultValue="") String graphURI) throws GraphDBWorkbenchException {
        Pair<List<DependencyClass>, Boolean> dependencyClassListPair = this.getDependencyClassList(mode, graphURI);
        LinkedList newDependencyClassList = dependencyClassListPair.getLeft();
        Boolean hasChanged = dependencyClassListPair.getRight();
        return new ResponseEntity(newDependencyClassList != null ? newDependencyClassList : new LinkedList(), (HttpStatusCode)(hasChanged != false ? HttpStatus.MULTI_STATUS : HttpStatus.OK));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"predicates"})
    public ResponseEntity<List<DependencyPredicate>> getDependencyPredicates(@RequestParam String from, @RequestParam String to, @RequestParam(required=false, defaultValue="all") String mode, @RequestParam(required=false, defaultValue="") String graphURI) throws GraphDBWorkbenchException {
        return new ResponseEntity(this.getDependenciesPredicates(from, to, mode, graphURI), (HttpStatusCode)HttpStatus.OK);
    }

    private List<DependencyClass> getClassesSortedByInCount(List<DependencyClass> dependencyClassList) {
        List filterHasIn = dependencyClassList.stream().sorted((o1, o2) -> Long.compare(o2.getInConnectionsSum(), o1.getInConnectionsSum())).collect(Collectors.toList());
        return filterHasIn.stream().map(c -> new DependencyClass(c.getName(), c.getInConnections().stream().map(conn -> new DependencyEdge(conn.getDependencyClass(), conn.getInWeight(), 0L)).sorted().collect(Collectors.toList()))).collect(Collectors.toList());
    }

    private List<DependencyClass> getClassesSortedByOutCount(List<DependencyClass> dependencyClassList) {
        List filterHasIn = dependencyClassList.stream().sorted((o1, o2) -> Long.compare(o2.getOutConnectionsSum(), o1.getOutConnectionsSum())).collect(Collectors.toList());
        return filterHasIn.stream().map(c -> new DependencyClass(c.getName(), c.getOutConnections().stream().map(conn -> new DependencyEdge(conn.getDependencyClass(), 0L, conn.getOutWeight())).sorted().collect(Collectors.toList()))).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"matrix"})
    public ResponseEntity<Pair<List<String>, long[][]>> getDependenciesMatrix(@RequestParam(required=false) String[] classes, @RequestParam(required=false, defaultValue="all") String mode, @RequestParam(required=false, defaultValue="") String graphURI) throws GraphDBWorkbenchException {
        List<DependencyClass> dependencyClassList = this.getDependencyClassList(mode, graphURI).getLeft();
        if (classes == null) {
            classes = new String[]{};
        }
        HashSet<String> uniqueIncludes = new HashSet<String>(Arrays.asList(classes));
        List selectedClasses = dependencyClassList.stream().filter(dc -> uniqueIncludes.contains(dc.getName())).sorted().collect(Collectors.toList());
        selectedClasses = selectedClasses.stream().filter(c -> c.getTotalSum() > 0L).collect(Collectors.toList());
        long[][] dependencyMatrix = new long[selectedClasses.size()][selectedClasses.size()];
        for (int i = 0; i < selectedClasses.size(); ++i) {
            for (int j = i; j < selectedClasses.size(); ++j) {
                DependencyClass fromDC = (DependencyClass)selectedClasses.get(i);
                DependencyClass toDC = (DependencyClass)selectedClasses.get(j);
                DependencyEdge dependencyEdge = fromDC.getConnections().stream().filter(de -> de.getDependencyClass().equals(toDC.getName())).findFirst().orElse(null);
                dependencyMatrix[i][j] = dependencyEdge != null ? dependencyEdge.getOutWeight() : 0L;
                dependencyMatrix[j][i] = dependencyEdge != null ? dependencyEdge.getInWeight() : 0L;
            }
        }
        List collectSelectedNames = selectedClasses.stream().map(DependencyClass::getName).collect(Collectors.toList());
        return new ResponseEntity(new Pair(collectSelectedNames, dependencyMatrix), (HttpStatusCode)HttpStatus.OK);
    }

    private Pair<List<DependencyClass>, Boolean> getDependencyClassList(String graphURI) throws GraphDBWorkbenchException {
        return this.getDependencyClassList(null, graphURI);
    }

    private Pair<List<DependencyClass>, Boolean> getDependencyClassList(String mode, String graphURI) throws GraphDBWorkbenchException {
        List<DependencyClass> dependencyClassList = this.calculateDependencyStatistics(graphURI);
        boolean hasChanged = this.isPluginDataChanged(graphURI);
        if (mode == null) {
            return new Pair<List<DependencyClass>, Boolean>(dependencyClassList, hasChanged);
        }
        if ("in".equals(mode)) {
            return new Pair<List<DependencyClass>, Boolean>(this.getClassesSortedByInCount(dependencyClassList), hasChanged);
        }
        if ("out".equals(mode)) {
            return new Pair<List<DependencyClass>, Boolean>(this.getClassesSortedByOutCount(dependencyClassList), hasChanged);
        }
        return new Pair<List<DependencyClass>, Boolean>(dependencyClassList, hasChanged);
    }

    private List<DependencyClass> calculateDependencyStatistics(final String graphURI) throws GraphDBWorkbenchException {
        SemanticRepository semanticRepository;
        SemanticRepository semanticRepository2 = semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository2);
        return (List)new SemanticRepository.WithConnection<List<DependencyClass>>(semanticRepository2){

            protected List<DependencyClass> doInConnection() throws RepositoryException {
                try {
                    HashMap<String, Map<String, Long>> inConnections = new HashMap<String, Map<String, Long>>();
                    HashMap<String, Map<String, Long>> outConnections = new HashMap<String, Map<String, Long>>();
                    TupleQueryResult result = this.prepareAndEvaluate(DependenciesController.this.modifyQuery(DependenciesController.GET_DEPENDENCIES_QUERY, graphURI));
                    while (result.hasNext()) {
                        BindingSet next = (BindingSet)result.next();
                        String from = next.getBinding("a").getValue().stringValue();
                        from = DependenciesController.this.uriPrefixService.resolveNamespaces((Collection)semanticRepository.getNamespaces(), from);
                        String to = next.getBinding("b").getValue().stringValue();
                        to = DependenciesController.this.uriPrefixService.resolveNamespaces((Collection)semanticRepository.getNamespaces(), to);
                        long count = ((Literal)next.getBinding("c").getValue()).longValue();
                        DependenciesController.this.addConnection(from, to, count, outConnections);
                        DependenciesController.this.addConnection(to, from, count, inConnections);
                    }
                    HashSet allClasses = new HashSet();
                    allClasses.addAll(inConnections.keySet());
                    allClasses.addAll(outConnections.keySet());
                    Function<String, DependencyClass> constructDependencyClass = s -> {
                        HashSet allConnectedClasses = new HashSet();
                        allConnectedClasses.addAll(((Map)inConnections.getOrDefault(s, new HashMap())).keySet());
                        allConnectedClasses.addAll(((Map)outConnections.getOrDefault(s, new HashMap())).keySet());
                        List<DependencyEdge> connectionsSorted = allConnectedClasses.stream().map(clazz -> new DependencyEdge((String)clazz, ((Map)inConnections.getOrDefault(s, new HashMap())).getOrDefault(clazz, 0L), ((Map)outConnections.getOrDefault(s, new HashMap())).getOrDefault(clazz, 0L))).sorted().collect(Collectors.toList());
                        return new DependencyClass((String)s, connectionsSorted);
                    };
                    return new LinkedList(allClasses).stream().map(constructDependencyClass).sorted().collect(Collectors.toList());
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    LOG.error("Cannot get dependencies from plugin", e);
                    return null;
                }
            }
        }.run();
    }

    private void addConnection(String from, String to, long count, Map<String, Map<String, Long>> connections) {
        if (!connections.containsKey(from)) {
            connections.put(from, new HashMap());
        }
        connections.get(from).put(to, count);
    }

    private boolean runUpdateDependencies(final String graphURI) throws GraphDBWorkbenchException {
        SemanticRepository repo;
        SemanticRepository semanticRepository = repo = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        return (Boolean)new SemanticRepository.WithConnection<Boolean>(semanticRepository){

            protected Boolean doInConnection() throws RepositoryException {
                try {
                    this.prepareAndEvaluateBoolean(DependenciesController.this.modifyQuery(DependenciesController.UPDATE_DEPENDENCIES_QUERY, graphURI));
                    return true;
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    LOG.error("Cannot execute update query", e);
                    return false;
                }
            }
        }.run();
    }

    private boolean isPluginAvailable() throws GraphDBWorkbenchException {
        SemanticRepository repository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        return (Boolean)new SemanticRepository.WithConnection<Boolean>(this, repository){

            protected Boolean doInConnection() throws RepositoryException {
                try {
                    return this.prepareAndEvaluateBoolean(DependenciesController.DEPENDENCIES_PLUGIN_QUERY);
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    LOG.error("Cannot check dependencies plugin status", e);
                    return false;
                }
            }
        }.run();
    }

    private List<DependencyPredicate> getDirectedDependenciesPredicates(String from, String to, final String direction, String graphURI) throws GraphDBWorkbenchException {
        SemanticRepository repository;
        final String query = StringUtils.replace((String)StringUtils.replace((String)this.modifyQuery(GET_DEPENDENCIES_PREDICATES_QRY, graphURI), (String)"{{fromClass}}", (String)from), (String)"{{toClass}}", (String)to);
        SemanticRepository semanticRepository = repository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        return (List)new SemanticRepository.WithConnection<List<DependencyPredicate>>(semanticRepository){

            protected List<DependencyPredicate> doInConnection() throws RepositoryException {
                LinkedList<DependencyPredicate> results = new LinkedList<DependencyPredicate>();
                try {
                    TupleQueryResult tupleQueryResult = this.prepareAndEvaluate(query);
                    while (tupleQueryResult.hasNext()) {
                        BindingSet next = (BindingSet)tupleQueryResult.next();
                        String predicate = next.getBinding("p").getValue().stringValue();
                        DependencyPredicate dependencyPredicate = new DependencyPredicate(DependenciesController.this.uriPrefixService.resolveNamespaces((Collection)repository.getNamespaces(), predicate), Integer.valueOf(next.getBinding("c").getValue().stringValue()), direction);
                        results.add(dependencyPredicate);
                    }
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    LOG.error("Cannot get dependencies for classes", e);
                }
                return results;
            }
        }.run();
    }

    private List<DependencyPredicate> getDependenciesPredicates(String from, String to, String mode, String graphURI) throws GraphDBWorkbenchException {
        from = "<" + this.uriPrefixService.prefixToFullURI((Collection)this.semanticDataManagement.getCurrentRepositoryOrThrow().getNamespaces(), (String)from) + ">";
        to = "<" + this.uriPrefixService.prefixToFullURI((Collection)this.semanticDataManagement.getCurrentRepositoryOrThrow().getNamespaces(), (String)to) + ">";
        List<Object> outs = new LinkedList();
        List<Object> ins = new LinkedList();
        if (mode.equals("out") || ((String)from).equals(to)) {
            outs = this.getDirectedDependenciesPredicates((String)from, (String)to, mode, graphURI);
        } else if (mode.equals("in")) {
            ins = this.getDirectedDependenciesPredicates((String)to, (String)from, mode, graphURI);
        } else {
            outs = this.getDirectedDependenciesPredicates((String)from, (String)to, "out", graphURI);
            ins = this.getDirectedDependenciesPredicates((String)to, (String)from, "in", graphURI);
        }
        LinkedList all = new LinkedList();
        all.addAll(outs);
        all.addAll(ins);
        return all.stream().sorted().collect(Collectors.toList());
    }

    private String getDependenciesPluginStatus(final String graphURI) throws GraphDBWorkbenchException {
        SemanticRepository repository;
        SemanticRepository semanticRepository = repository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        return (String)new SemanticRepository.WithConnection<String>(semanticRepository){

            protected String doInConnection() throws RepositoryException {
                try {
                    TupleQueryResult result = this.prepareAndEvaluate(DependenciesController.this.modifyQuery(DependenciesController.DEPENDENCIES_STATUS_QUERY, graphURI));
                    if (result.hasNext()) {
                        return ((BindingSet)result.next()).getValue("status").stringValue();
                    }
                    LOG.error("Cannot get dependencies status, no result for query");
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    LOG.error("Cannot not get dependencies plugin status", e);
                }
                return DependenciesController.ERROR_STATUS;
            }
        }.run();
    }

    private String modifyQuery(String originalQuery, String graphURI) {
        return StringUtils.isEmpty((CharSequence)graphURI) ? StringUtils.replace((String)StringUtils.replace((String)originalQuery, (String)"{{fromGraph}}", (String)""), (String)"{{closingBracket}}", (String)"") : StringUtils.replace((String)StringUtils.replace((String)originalQuery, (String)"{{fromGraph}}", (String)("GRAPH <" + graphURI + "> { ")), (String)"{{closingBracket}}", (String)" }");
    }

    private boolean isPluginDataChanged(final String graphURI) throws GraphDBWorkbenchException {
        SemanticRepository repository;
        SemanticRepository semanticRepository = repository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        return (Boolean)new SemanticRepository.WithConnection<Boolean>(semanticRepository){

            protected Boolean doInConnection() throws RepositoryException {
                try {
                    return this.prepareAndEvaluateBoolean(DependenciesController.this.modifyQuery(DependenciesController.PLUGIN_DATA_CHANGED, graphURI));
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    LOG.error("Cannot check if dependencies plugin data is up to date", e);
                    return false;
                }
            }
        }.run();
    }
}

