/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.subscriptions;

import java.util.regex.Pattern;

public class Utils {
    private static final Pattern QUOTE = Pattern.compile("\"");
    private static final Pattern ESCAPED_QUOTE = Pattern.compile("\\\\\"");
    private static final String DOUBLE_ESCAPED_QUOTE = "\\\\\\\\\"";

    private Utils() {
    }

    public static String toSubscriptionType(String returnType) {
        return returnType.substring(0, returnType.lastIndexOf("_Subscription"));
    }

    public static String quoteToDoubleEscapedQuote(String input) {
        return QUOTE.matcher(input).replaceAll(DOUBLE_ESCAPED_QUOTE);
    }

    public static String escapedQuoteToDoubleEscapedQuote(String input) {
        return ESCAPED_QUOTE.matcher(input).replaceAll(DOUBLE_ESCAPED_QUOTE);
    }
}

