/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.plugins;

import com.ontotext.platform.plugins.PluginRuntimeException;
import com.ontotext.subscriptions.Utils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class PluginQueries {
    public static final String PLUGIN_NAME_BINDING = "cntUri";
    public static final String PLUGIN_STATUS_BINDING = "cntStatus";
    public static final String LIST_ALL_PLUGINS_TEMPLATE = PluginQueries.loadResource("list-all-template.sparql");
    private static final String PLUGIN_EXISTS_TEMPLATE = PluginQueries.loadResource("exists-template.sparql");
    private static final String CREATE_PLUGIN_TEMPLATE = PluginQueries.loadResource("create-template.sparql");
    private static final String DROP_PLUGIN_TEMPLATE = PluginQueries.loadResource("drop-template.sparql");

    private PluginQueries() {
    }

    static String buildExistsQuery(String name, String connIri, String connInstIri) {
        return String.format(PLUGIN_EXISTS_TEMPLATE, connIri, connInstIri, PLUGIN_STATUS_BINDING, name);
    }

    static String buildListAllQuery(String connIri) {
        return String.format(LIST_ALL_PLUGINS_TEMPLATE, connIri, PLUGIN_NAME_BINDING);
    }

    static String buildCreateQuery(String name, Object configuration, String connIri, String connInstIri) {
        return Utils.escapedQuoteToDoubleEscapedQuote(String.format(CREATE_PLUGIN_TEMPLATE, connIri, connInstIri, name, configuration));
    }

    static String buildRemoveQuery(String name, String connIri, String connInstIri) {
        return String.format(DROP_PLUGIN_TEMPLATE, connIri, connInstIri, name);
    }

    private static String loadResource(String resource) {
        try {
            return IOUtils.resourceToString((String)("/entity-change-plugin-queries/" + resource), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new PluginRuntimeException("Failed to load query resource: " + resource);
        }
    }
}

