/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.plugins;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONObject;

public class FieldBuilder {
    private String fieldName;
    private FieldNameTransform fieldNameTransform;
    private LinkedList<String> propertyChain;
    private String valueFilter;
    private String documentFilter;
    private String defaultValue;
    private Boolean indexed;
    private Boolean stored;
    private Boolean analyzed;
    private boolean multivalued;
    private Boolean ignoreMalformed = Boolean.TRUE;
    private String datatype;
    private Map<String, Object> nativeSettings;
    private List<JSONObject> objectFields;
    private Integer startFromParent;
    private String analyzer;
    private static final Set<String> IGNORE_MALFORMED_SUPPORT_TYPES = Stream.of("scaled_float", "integer", "double", "long", "byte", "short", "float").map(type -> "native:" + type).collect(Collectors.toSet());

    protected FieldBuilder() {
    }

    public FieldBuilder name(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public FieldBuilder fieldNameTransform(FieldNameTransform fieldNameTransform) {
        this.fieldNameTransform = fieldNameTransform;
        return this;
    }

    public FieldBuilder multivalued(boolean multivalued) {
        this.multivalued = multivalued;
        return this;
    }

    public FieldBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public FieldBuilder property(String property) {
        if (this.propertyChain == null) {
            this.propertyChain = new LinkedList();
        }
        this.propertyChain.add(property);
        return this;
    }

    public FieldBuilder propertyFirst(String property) {
        if (this.propertyChain == null) {
            this.propertyChain = new LinkedList();
        }
        this.propertyChain.addFirst(property);
        return this;
    }

    public FieldBuilder datatype(String datatype) {
        this.datatype = datatype;
        return this;
    }

    public FieldBuilder objectField(JSONObject objectField) {
        if (this.objectFields == null) {
            this.objectFields = new LinkedList<JSONObject>();
        }
        this.objectFields.add(objectField);
        return this;
    }

    public FieldBuilder nativeSetting(String key, Object value) {
        if (this.nativeSettings == null) {
            this.nativeSettings = new HashMap<String, Object>();
        }
        this.nativeSettings.put(key, value);
        return this;
    }

    public FieldBuilder ignoreMalformed(boolean ignoreMalformed) {
        this.ignoreMalformed = ignoreMalformed;
        return this;
    }

    public FieldBuilder indexed(boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    public FieldBuilder stored(boolean stored) {
        this.stored = stored;
        return this;
    }

    public FieldBuilder analyzed(boolean analyzed) {
        this.analyzed = analyzed;
        return this;
    }

    public FieldBuilder valueFilter(String valueFilter) {
        this.valueFilter = valueFilter;
        return this;
    }

    public FieldBuilder documentFilter(String documentFilter) {
        this.documentFilter = documentFilter;
        return this;
    }

    public FieldBuilder defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public FieldBuilder startFromParent(int startFromParent) {
        this.startFromParent = startFromParent;
        return this;
    }

    public JSONObject build() {
        if (Boolean.TRUE.equals(this.ignoreMalformed) && IGNORE_MALFORMED_SUPPORT_TYPES.contains(this.datatype)) {
            this.nativeSetting("ignore_malformed", true);
        }
        JSONObject obj = new JSONObject().put("fieldName", (Object)Objects.requireNonNull(this.fieldName)).put("propertyChain", (Collection)Objects.requireNonNull(this.propertyChain)).put("multivalued", this.multivalued);
        if (this.fieldNameTransform != null) {
            FieldBuilder.putIfNotNull(obj, this.fieldNameTransform.toString(), "fieldNameTransform");
        }
        FieldBuilder.putIfNotNull(obj, this.defaultValue, "defaultValue");
        FieldBuilder.putIfNotNull(obj, this.datatype, "datatype");
        FieldBuilder.putIfNotNull(obj, this.analyzer, "analyzer");
        FieldBuilder.putIfNotNull(obj, this.objectFields, "objectFields");
        FieldBuilder.putIfNotNull(obj, this.valueFilter, "valueFilter");
        FieldBuilder.putIfNotNull(obj, this.documentFilter, "documentFilter");
        FieldBuilder.putIfNotNull(obj, this.nativeSettings, "nativeSettings");
        FieldBuilder.putIfNotNull(obj, this.ignoreMalformed, "ignoreInvalidValues");
        FieldBuilder.putIfNotNull(obj, this.indexed, "indexed");
        FieldBuilder.putIfNotNull(obj, this.stored, "stored");
        FieldBuilder.putIfNotNull(obj, this.analyzed, "analyzed");
        FieldBuilder.putIfNotNull(obj, this.startFromParent, "startFromParent");
        if (this.multivalued) {
            obj.put("array", true);
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldBuilder builder = (FieldBuilder)obj;
        return Objects.equals(this.fieldName, builder.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName);
    }

    private static void putIfNotNull(JSONObject obj, Object value, String key) {
        if (value != null) {
            obj.put(key, value);
        }
    }

    public static enum FieldNameTransform {
        NONE("none"),
        PREDICATE("predicate"),
        LOCALNAME("predicate.localName");

        private final String jsonValue;

        private FieldNameTransform(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        public String toString() {
            return this.jsonValue;
        }
    }
}

