/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.plugins;

import com.ontotext.graphql.compiler.querymodel.Bound;
import com.ontotext.graphql.compiler.querymodel.FilterVar;
import com.ontotext.graphql.compiler.querymodel.Gt;
import com.ontotext.graphql.compiler.querymodel.Gte;
import com.ontotext.graphql.compiler.querymodel.LangVar;
import com.ontotext.graphql.compiler.querymodel.Lt;
import com.ontotext.graphql.compiler.querymodel.Lte;
import com.ontotext.graphql.compiler.querymodel.Or;
import com.ontotext.graphql.compiler.querymodel.Regex;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.All;
import com.ontotext.models.query.AllExists;
import com.ontotext.models.query.And;
import com.ontotext.models.query.CaseInsensitiveRegex;
import com.ontotext.models.query.CaseInsensitiveRegexMismatch;
import com.ontotext.models.query.Equals;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.GreaterThan;
import com.ontotext.models.query.GreaterThanEquals;
import com.ontotext.models.query.In;
import com.ontotext.models.query.LessThan;
import com.ontotext.models.query.LessThanEquals;
import com.ontotext.models.query.Minus;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.NotEquals;
import com.ontotext.models.query.NotIn;
import com.ontotext.models.query.RegexMismatch;
import com.ontotext.models.query.SelectDistinct;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.models.query.StringContains;
import com.ontotext.models.query.StringEndsWith;
import com.ontotext.models.query.StringStartWith;
import com.ontotext.models.query.UniqueLang;
import com.ontotext.platform.plugins.FieldBuilder;
import com.ontotext.soaas.common.SparqlUtil;
import graphql.GraphQLError;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConnectorFilterBuilder
implements ExpressionVisitor<SparqlNode, FilterContext> {
    private static final String WILDCARD = ".*";
    private static final char QUOTE = '\"';
    private boolean replaceId = false;
    private boolean useFilterVars = false;

    public ConnectorFilterBuilder replaceId(boolean replaceId) {
        this.replaceId = replaceId;
        return this;
    }

    public ConnectorFilterBuilder useFilterVars(boolean useFilterVars) {
        this.useFilterVars = useFilterVars;
        return this;
    }

    public SparqlNode visit(All target, FilterContext context) {
        throw new UnsupportedOperationException();
    }

    public SparqlNode visit(AllExists target, FilterContext context) {
        throw new UnsupportedOperationException();
    }

    public SparqlNode visit(And target, FilterContext context) {
        return this.and((Expression)target, context);
    }

    public SparqlNode visit(CaseInsensitiveRegex target, FilterContext context) {
        return new Regex(context.parentVar, null, target.getValue().toString(), false, false);
    }

    public SparqlNode visit(CaseInsensitiveRegexMismatch target, FilterContext context) {
        return this.not((SparqlNode)new Regex(context.parentVar, null, target.getValue().toString(), false, false));
    }

    public SparqlNode visit(Equals target, FilterContext context) {
        return this.equals((ExpressionTerm<Object>)target, context);
    }

    public SparqlNode visit(Exists target, FilterContext context) {
        return this.inSparqlSequence((Expression)target, context);
    }

    public SparqlNode visit(GreaterThan target, FilterContext context) {
        return new Gt(context.parentVar, Value.valueFromObject((Object)target.getValue(), (SomlSchema)context.soml));
    }

    public SparqlNode visit(GreaterThanEquals target, FilterContext context) {
        return new Gte(context.parentVar, Value.valueFromObject((Object)target.getValue(), (SomlSchema)context.soml));
    }

    public SparqlNode visit(In target, FilterContext context) {
        return this.in((Collection)target.getValue(), context);
    }

    public SparqlNode visit(LessThan target, FilterContext context) {
        return new Lt(context.parentVar, Value.valueFromObject((Object)target.getValue(), (SomlSchema)context.soml));
    }

    public SparqlNode visit(LessThanEquals target, FilterContext context) {
        return new Lte(context.parentVar, Value.valueFromObject((Object)target.getValue(), (SomlSchema)context.soml));
    }

    public SparqlNode visit(Minus target, FilterContext context) {
        return this.not((SparqlNode)this.and((Expression)target, context));
    }

    public SparqlNode visit(Node target, FilterContext context) {
        if (this.shouldSkipTheNodeSelection(target, context)) {
            return (SparqlNode)((Expression)target.getValue()).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context.forVar(context.parentVar, target.getPropertyShape()));
        }
        Var var = this.getNodeVar(target, context);
        FilterContext childContext = context.forVar(var, target.getPropertyShape());
        if (target.isExistsCheck()) {
            return new Bound((SparqlNode)var);
        }
        SparqlNode childClause = (SparqlNode)((Expression)target.getValue()).accept((ExpressionVisitor)this, (ExpressionVisitorContext)childContext);
        if (context.skipBoundClauses) {
            return childClause;
        }
        return new com.ontotext.graphql.compiler.querymodel.And(Arrays.asList(new Bound((SparqlNode)var), childClause));
    }

    public SparqlNode visit(Not target, FilterContext context) {
        return this.not((SparqlNode)this.and((Expression)target, context));
    }

    public SparqlNode visit(NotEquals target, FilterContext context) {
        return this.not((SparqlNode)this.equals((ExpressionTerm<Object>)target, context));
    }

    public SparqlNode visit(NotIn target, FilterContext context) {
        return this.not(this.in((Collection)target.getValue(), context));
    }

    public SparqlNode visit(com.ontotext.models.query.Or target, FilterContext context) {
        return new Or((Collection)((List)target.getValue()).stream().map(expr -> (SparqlNode)expr.accept((ExpressionVisitor)this, (ExpressionVisitorContext)context)).collect(Collectors.toList()));
    }

    public SparqlNode visit(com.ontotext.models.query.Regex target, FilterContext context) {
        return new Regex(context.parentVar, null, target.getValue().toString(), true, false);
    }

    public SparqlNode visit(RegexMismatch target, FilterContext context) {
        return this.not((SparqlNode)new Regex(context.parentVar, null, target.getValue().toString(), true, false));
    }

    public SparqlNode visit(SelectDistinct target, FilterContext context) {
        return this.inSparqlSequence((Expression)target, context);
    }

    public SparqlNode visit(com.ontotext.models.query.Value target, FilterContext context) {
        throw new UnsupportedOperationException();
    }

    public SparqlNode visit(ExpressionCollection target, FilterContext context) {
        if (target.getTerms().size() == 1) {
            return (SparqlNode)((ExpressionTerm)target.getTerms().get(0)).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context);
        }
        return this.and((Expression)target, context);
    }

    public SparqlNode visit(StringStartWith target, FilterContext context) {
        return new Regex(context.parentVar, null, this.wildcardAtTheEnd(target.getValue().toString()), true, false);
    }

    public SparqlNode visit(StringEndsWith target, FilterContext context) {
        return new Regex(context.parentVar, null, this.wildcardAtTheStart(target.getValue().toString()), true, false);
    }

    public SparqlNode visit(StringContains target, FilterContext context) {
        return new Regex(context.parentVar, null, this.wildcardAtTheStartAndEnd(target.getValue().toString()), true, false);
    }

    public SparqlNode visit(UniqueLang target, FilterContext context) {
        throw new UnsupportedOperationException("Unique lang check is not supported in connector filters");
    }

    private boolean shouldSkipTheNodeSelection(Node target, FilterContext context) {
        if (target.getPropertyShape().getName().equals("value") && context.isParentLangProp()) {
            return true;
        }
        return target.getName().equals("id") && context.parentVar != null;
    }

    private Var getNodeVar(Node target, FilterContext context) {
        if (target.getPropertyShape().getName().equals("lang") && context.isParentLangProp()) {
            return new LangVar(context.parentVar);
        }
        if (this.replaceId && target.getName().equals("id")) {
            return new Var("entityId");
        }
        PropertyShape propertyShape = target.getPropertyShape();
        if (propertyShape.getName().equals("name")) {
            ConnectorFilterBuilder.checkIfSparqlTemplate(propertyShape.getRdfProperty());
            propertyShape = propertyShape.getContainedIn().getContainedIn().getProperty(propertyShape.getRdfProperty()).orElse(propertyShape);
            ConnectorFilterBuilder.checkIfSparqlTemplate(propertyShape.getRdfProperty());
        }
        Prefixes pfxes = context.soml.getPrefixes();
        Object varName = pfxes.toName(propertyShape.getName());
        if (context.isInFragment(propertyShape)) {
            varName = pfxes.toName(target.getShape().getId()) + "_" + (String)varName;
        }
        if (target.getPropertyShape().isLiteral()) {
            varName = (String)varName + "_value";
        }
        return this.useFilterVars ? new FilterVar(context.parentVar, (String)varName, 0) : new Var(context.parentVar, (String)varName);
    }

    private static void checkIfSparqlTemplate(String property) {
        if (SparqlUtil.isSparqlTemplate((String)property)) {
            throw new InvalidOperationException("Invalid filter argument", (GraphQLError)SimpleGraphQlError.newValidationError((SourceLocation)null, (String)("Not allowed to use property '" + property + "' as it's described with SPARQL template for connector filter")));
        }
    }

    private com.ontotext.graphql.compiler.querymodel.And and(Expression target, FilterContext context) {
        return new com.ontotext.graphql.compiler.querymodel.And((Collection)((List)target.getValue()).stream().map(expr -> (SparqlNode)expr.accept((ExpressionVisitor)this, (ExpressionVisitorContext)context)).collect(Collectors.toList()));
    }

    private SparqlNode in(Collection<Object> value, FilterContext context) {
        return new com.ontotext.graphql.compiler.querymodel.In((SparqlNode)context.parentVar, value.stream().map(val -> Value.valueFromObject((Object)val, (SomlSchema)context.soml)).toList());
    }

    private com.ontotext.graphql.compiler.querymodel.Equals equals(ExpressionTerm<Object> target, FilterContext context) {
        return new com.ontotext.graphql.compiler.querymodel.Equals((SparqlNode)context.parentVar, (SparqlNode)Value.valueFromObject((Object)target.getValue(), (SomlSchema)context.soml));
    }

    private com.ontotext.graphql.compiler.querymodel.Not not(SparqlNode node) {
        return new com.ontotext.graphql.compiler.querymodel.Not(node);
    }

    private SparqlNodeSequence inSparqlSequence(Expression target, FilterContext context) {
        return ((List)target.getValue()).stream().map(value -> (SparqlNode)value.accept((ExpressionVisitor)this, (ExpressionVisitorContext)context)).reduce(new SparqlNodeSequence(), SparqlNodeSequence::add, SparqlNodeSequence::addAll);
    }

    private String wildcardAtTheEnd(String value) {
        if (this.stringSurroundedByQuotes(value)) {
            return new StringBuilder().append('\"').append('^').append(value, 1, value.length() - 1).append(WILDCARD).append('\"').toString();
        }
        return "^" + value + WILDCARD;
    }

    private String wildcardAtTheStart(String value) {
        if (this.stringSurroundedByQuotes(value)) {
            return new StringBuilder().append('\"').append(WILDCARD).append(value, 1, value.length() - 1).append('$').append('\"').toString();
        }
        return WILDCARD + value + "$";
    }

    private String wildcardAtTheStartAndEnd(String value) {
        if (this.stringSurroundedByQuotes(value)) {
            return new StringBuilder().append('\"').append(WILDCARD).append(value, 1, value.length() - 1).append(WILDCARD).append('\"').toString();
        }
        return WILDCARD + value + WILDCARD;
    }

    private boolean stringSurroundedByQuotes(String value) {
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    public static class FilterContext
    implements ExpressionVisitorContext {
        private final SomlSchema soml;
        private final Shape shape;
        private final Var parentVar;
        private final PropertyShape parentShape;
        private final boolean not;
        private final boolean skipBoundClauses;
        Set<FilterContext> childContexts = new HashSet<FilterContext>();

        public FilterContext(SomlSchema soml, Shape shape) {
            this(soml, null, null, false, shape, false);
        }

        public FilterContext(SomlSchema soml, Shape shape, boolean skipBoundClauses) {
            this(soml, null, null, false, shape, skipBoundClauses);
        }

        public FilterContext forVar(Var var, PropertyShape propertyShape) {
            FilterContext childContext = new FilterContext(this.soml, var, propertyShape, this.not, (Shape)this.soml.getObjects().get((Object)propertyShape.getRange()), this.skipBoundClauses);
            this.childContexts.add(childContext);
            return childContext;
        }

        public boolean isParentLangProp() {
            return this.parentShape != null && this.parentShape.isScalarType() && this.parentShape.getScalarType().isLangStringSupported();
        }

        public boolean isInFragment(PropertyShape propertyShape) {
            if (this.shape == null) {
                return false;
            }
            return !this.shape.getProperty(propertyShape.getName()).isPresent();
        }

        public Stream<FieldBuilder> getFilterFields() {
            if (this.parentVar == null || this.parentShape == null || this.parentShape.getRdfProp().equals("lang")) {
                return this.childContexts.stream().flatMap(FilterContext::getFilterFields).distinct();
            }
            return Stream.concat(Stream.of(new FieldBuilder().name(this.parentVar.getFullName()).multivalued(this.parentShape.isMultivalued()).indexed(false).stored(false)), this.childContexts.stream().flatMap(FilterContext::getFilterFields)).map(builder -> builder.propertyFirst(this.getRdfProperty())).distinct();
        }

        private String getRdfProperty() {
            if (this.parentShape.getName().equals("id")) {
                return "$self";
            }
            Optional inverseAliasProperty = this.parentShape.getInverseAliasProperty();
            if (inverseAliasProperty.isPresent()) {
                String inverseRdf = (String)inverseAliasProperty.get();
                ConnectorFilterBuilder.checkIfSparqlTemplate(inverseRdf);
                return "^" + this.soml.getPrefixes().toIri(inverseRdf);
            }
            String rdfProperty = this.parentShape.getRdfProperty();
            ConnectorFilterBuilder.checkIfSparqlTemplate(rdfProperty);
            return this.soml.getPrefixes().toIri(rdfProperty);
        }

        private FilterContext(SomlSchema soml, Var parentVar, PropertyShape parentShape, boolean not, Shape shape, boolean skipBoundClauses) {
            this.soml = soml;
            this.parentVar = parentVar;
            this.parentShape = parentShape;
            this.not = not;
            this.shape = shape;
            this.skipBoundClauses = skipBoundClauses;
        }
    }
}

