/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;

public class NodeUtils {
    public static final ObjectMapper mapper = new ObjectMapper();

    public static void evalLets(Scope scope, JsonNode input, LetExpression[] lets) {
        if (lets == null) {
            return;
        }
        for (int ix = 0; ix < lets.length; ++ix) {
            String var = lets[ix].getVariable();
            JsonNode val = lets[ix].apply(scope, input);
            scope.setValue(lets[ix].getSlot(), val);
        }
    }

    public static boolean isTrue(JsonNode value) {
        return !(value == BooleanNode.FALSE || value.isObject() && value.size() == 0 || value.isTextual() && value.asText().length() == 0 || value.isArray() && value.size() == 0 || value.isNumber() && value.doubleValue() == 0.0 || value.isNull());
    }

    public static boolean isValue(JsonNode value) {
        return !(value.isNull() || value.isObject() && value.size() == 0 || value.isArray() && value.size() == 0);
    }

    public static JsonNode toJson(boolean value) {
        if (value) {
            return BooleanNode.TRUE;
        }
        return BooleanNode.FALSE;
    }

    public static JsonNode toJson(double value) {
        return new DoubleNode(value);
    }

    public static JsonNode toJson(String[] array) {
        ArrayNode node = mapper.createArrayNode();
        for (int ix = 0; ix < array.length; ++ix) {
            node.add(array[ix]);
        }
        return node;
    }

    public static String toString(JsonNode value, boolean nullok) {
        if (value.isTextual()) {
            return value.asText();
        }
        if (value.isNull() && nullok) {
            return null;
        }
        return value.toString();
    }

    public static ArrayNode toArray(JsonNode value, boolean nullok) {
        if (value.isArray()) {
            return (ArrayNode)value;
        }
        if (value.isNull() && nullok) {
            return null;
        }
        throw new JsltException("Cannot convert " + value + " to array");
    }

    public static JsonNode number(JsonNode value, Location loc) {
        return NodeUtils.number(value, false, loc);
    }

    public static JsonNode number(JsonNode value, boolean strict, Location loc) {
        return NodeUtils.number(value, strict, loc, null);
    }

    public static JsonNode number(JsonNode value, boolean strict, Location loc, JsonNode fallback) {
        if (value.isNumber()) {
            return value;
        }
        if (value.isNull()) {
            if (fallback == null) {
                return value;
            }
            return fallback;
        }
        if (!value.isTextual()) {
            if (strict) {
                throw new JsltException("Can't convert " + value + " to number", loc);
            }
            if (fallback == null) {
                return NullNode.instance;
            }
            return fallback;
        }
        String number = value.asText();
        JsonNode numberNode = NodeUtils.parseNumber(number);
        if (numberNode == null || !numberNode.isNumber()) {
            if (fallback == null) {
                throw new JsltException("number(" + number + ") failed: not a number", loc);
            }
            return fallback;
        }
        return numberNode;
    }

    private static JsonNode parseNumber(String number) {
        char ch;
        int endInteger;
        if (number.length() == 0) {
            return null;
        }
        int pos = 0;
        if (number.charAt(0) == '-') {
            pos = 1;
        }
        if ((endInteger = NodeUtils.scanDigits(number, pos)) == pos) {
            return null;
        }
        if (endInteger == number.length()) {
            if (number.length() < 10) {
                return new IntNode(Integer.parseInt(number));
            }
            if (number.length() < 19) {
                return new LongNode(Long.parseLong(number));
            }
            return new BigIntegerNode(new BigInteger(number));
        }
        int intPart = Integer.parseInt(number.substring(0, endInteger));
        pos = endInteger;
        double value = intPart;
        if (number.charAt(pos) == '.') {
            int endDecimal;
            if ((endDecimal = NodeUtils.scanDigits(number, ++pos)) == pos) {
                return null;
            }
            long decimalPart = Long.parseLong(number.substring(endInteger + 1, endDecimal));
            int digits = endDecimal - endInteger - 1;
            if (intPart < 0) {
                decimalPart *= -1L;
            }
            value = (double)decimalPart / Math.pow(10.0, digits) + (double)intPart;
            pos = endDecimal;
            if (pos == number.length()) {
                return new DoubleNode(value);
            }
        }
        if ((ch = number.charAt(pos)) != 'e' && ch != 'E') {
            return null;
        }
        if (++pos == number.length()) {
            return null;
        }
        ch = number.charAt(pos);
        int sign = 1;
        if (ch == '+') {
            ++pos;
        } else if (ch == '-') {
            sign = -1;
            ++pos;
        }
        int endExponent = NodeUtils.scanDigits(number, pos);
        if (endExponent != number.length() || endExponent == pos) {
            return null;
        }
        int exponent = Integer.parseInt(number.substring(pos)) * sign;
        return new DoubleNode(value * Math.pow(10.0, exponent));
    }

    private static int scanDigits(String number, int pos) {
        while (pos < number.length() && NodeUtils.isDigit(number.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static ArrayNode convertObjectToArray(JsonNode object) {
        ArrayNode array = mapper.createArrayNode();
        Iterator it = object.fields();
        while (it.hasNext()) {
            Map.Entry item = (Map.Entry)it.next();
            ObjectNode element = mapper.createObjectNode();
            element.set("key", (JsonNode)new TextNode((String)item.getKey()));
            element.set("value", (JsonNode)item.getValue());
            array.add((JsonNode)element);
        }
        return array;
    }

    public static String indent(int level) {
        char[] indent = new char[level * 2];
        for (int ix = 0; ix < indent.length; ++ix) {
            indent[ix] = 32;
        }
        return new String(indent, 0, indent.length);
    }
}

