/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.web;

import com.ontotext.forest.core.web.BaserefTransformer;
import com.ontotext.forest.core.web.CacheContentUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class WelcomePageResourceHttpRequestHandler
extends ResourceHttpRequestHandler {
    private static final String BASEHREF_PAGE = "basehref.html";
    private static final String INDEX_PAGE = "index.html";
    private static final boolean ENABLE_CYPRESS_HACK = Boolean.parseBoolean(System.getProperty("enable.cypress.hack"));

    public void afterPropertiesSet() throws Exception {
        this.getResourceTransformers().add(new BaserefTransformer());
        super.afterPropertiesSet();
    }

    protected Resource getResource(HttpServletRequest request) throws IOException {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (path.endsWith(INDEX_PAGE)) {
            request.setAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, (Object)INDEX_PAGE);
        } else {
            request.setAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, (Object)(ENABLE_CYPRESS_HACK ? INDEX_PAGE : BASEHREF_PAGE));
        }
        return super.getResource(request);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getMethod().equals("GET") || request.getMethod().equals("HEAD")) {
            CacheContentUtil.setNoCache(response);
            String requestedMediaType = request.getHeader("Accept");
            if (requestedMediaType == null || requestedMediaType.startsWith("text/html")) {
                super.handleRequest(request, response);
            } else {
                response.sendError(HttpStatus.NOT_ACCEPTABLE.value());
            }
        } else {
            response.sendError(HttpStatus.METHOD_NOT_ALLOWED.value());
        }
    }
}

