/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.mvc.WebContentInterceptor;

public class UpdateCacheInterceptor
extends WebContentInterceptor {
    private static final String NO_CACHE_PROPERTY = "resources.nocache";
    private static final Integer SHORT_CACHE_PERIOD = 600;
    private boolean noCache;

    public UpdateCacheInterceptor() {
        this.setCacheControl(CacheControl.empty().mustRevalidate());
        this.setCacheSeconds(SHORT_CACHE_PERIOD);
        this.noCache = System.getProperty(NO_CACHE_PROPERTY) != null;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        if (this.noCache) {
            this.checkAndPrepare(request, response, 0, handler instanceof LastModified);
            return true;
        }
        return super.preHandle(request, response, handler);
    }
}

