/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.util.file;

import com.ontotext.forest.core.util.file.FileHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFFileHandler
implements FileHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final RDFFormat[] formats = new RDFFormat[]{RDFFormat.NTRIPLES, RDFFormat.N3, RDFFormat.RDFXML, RDFFormat.TURTLE, RDFFormat.TURTLESTAR, RDFFormat.TRIG, RDFFormat.TRIGSTAR, RDFFormat.TRIX};
    private RepositoryConnection connection;

    public RDFFileHandler(RepositoryConnection connection) {
        this.connection = connection;
    }

    @Override
    public void file(File file) {
        IRI context = SimpleValueFactory.getInstance().createIRI(file.toURI().toString());
        boolean loaded = false;
        for (RDFFormat format : formats) {
            try {
                this.connection.add((Reader)new BufferedReader(new FileReader(file, StandardCharsets.UTF_8), 0x100000), "http://ontotext.com/owlim#", format, new Resource[]{context});
                loaded = true;
                break;
            }
            catch (UnsupportedRDFormatException unsupportedRDFormatException) {
            }
            catch (RDFParseException rDFParseException) {
            }
            catch (RepositoryException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (!loaded) {
            this.logger.error("Failed to load " + file.getName() + ".");
        }
    }

    @Override
    public void directory(File directory) {
        this.logger.info("Loading files from: " + directory.getAbsolutePath() + ".");
    }
}

