/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.util;

import com.ontotext.forest.core.properties.AskablePropertyPlaceholderConfigurer;
import com.ontotext.forest.core.properties.ExtendedPropertyPlaceholderConfigurer;
import com.ontotext.graphdb.Config;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class ResourceUtils {
    @Autowired
    ExtendedPropertyPlaceholderConfigurer nonPersistentProperties;
    @Autowired
    private List<AskablePropertyPlaceholderConfigurer> properties;
    private File applicationDataDir;

    @PostConstruct
    public void init() {
        this.applicationDataDir = ResourceUtils.initApplicationDir();
    }

    public Object getProperty(String key) {
        Object property = null;
        if (this.properties != null) {
            AskablePropertyPlaceholderConfigurer bean;
            Iterator<AskablePropertyPlaceholderConfigurer> iterator = this.properties.iterator();
            while (iterator.hasNext() && (property = (bean = iterator.next()).getProperty(key)) == null) {
            }
        }
        return property != null ? (property instanceof String ? ResourceUtils.convert((String)property) : property) : property;
    }

    public Object getNewOrDeprecatedProperty(String keyNew, String keyDeprecated) {
        String deprecatedValue;
        Object result = this.getProperty(keyNew);
        if (Config.getProperty((String)keyNew) == null && (deprecatedValue = System.getProperty(keyDeprecated)) != null) {
            result = deprecatedValue;
        }
        return result;
    }

    private static Object convert(String value) {
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return Boolean.valueOf(value);
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public static String decorate(String str, Map<String, String> values) {
        Matcher m = Pattern.compile("\\$\\{[^}]*\\}").matcher(str);
        while (m.find()) {
            String key = m.group().replaceAll("^\\$\\{|\\}$", "");
            String value = values.get(key);
            if (value == null) continue;
            str = str.replaceAll("\\$\\{" + key + "\\}", Matcher.quoteReplacement(value.toString()));
        }
        return str;
    }

    public File getApplicationDataDir() {
        return this.applicationDataDir;
    }

    public static File initApplicationDir() {
        String defaultValue = Config.getDataDirectory();
        String dataDir = Config.getProperty((String)"graphdb.home.data", (String)System.getProperty("app.datadir", defaultValue));
        File applicationDataDir = new File(dataDir);
        try {
            if (!applicationDataDir.exists()) {
                FileUtils.forceMkdir((File)applicationDataDir);
            }
            Config.reportConfiguredDirectories();
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create application directory " + String.valueOf(applicationDataDir), e);
        }
        return applicationDataDir;
    }
}

