/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.serialization;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.ontotext.forest.core.serialization.UriJsonDeserializer;
import com.ontotext.forest.core.serialization.UriJsonSerializer;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Named
public class JacksonMessageConverterConfigURI {
    @Autowired
    @Qualifier(value="org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter")
    private RequestMappingHandlerAdapter rmha;

    @PostConstruct
    public void init() {
        List messageConverters = this.rmha.getMessageConverters();
        for (HttpMessageConverter messageConverter : messageConverters) {
            if (!(messageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            SimpleModule module = new SimpleModule("Forest Resource Jackson");
            module.addSerializer(IRI.class, (JsonSerializer)new UriJsonSerializer());
            module.addDeserializer(IRI.class, (JsonDeserializer)new UriJsonDeserializer());
            ((MappingJackson2HttpMessageConverter)messageConverter).getObjectMapper().registerModule((Module)module);
        }
    }
}

