/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.model.RdfTypedResource;
import com.ontotext.forest.core.util.RequestUtils;
import com.ontotext.trree.OwlimSchemaRepository;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticRepository.class);
    private static final String SYSINFO_QUERY = "DESCRIBE <http://www.ontotext.com/SYSINFO> from <http://www.ontotext.com/SYSINFO>";
    public static final String NAMESPACES_ATTRIBUTE = SemanticRepository.class.getName() + ".NAMESPACES_ATTRIBUTE";
    public static final String CONTEXTS_ATTRIBUTE = SemanticRepository.class.getName() + ".CONTEXTS_ATTRIBUTE";
    private final Supplier<Repository> repository;
    private final String repositoryID;
    private final boolean isLocal;

    protected SemanticRepository(Supplier<Repository> repository, String repositoryID, boolean isLocal) {
        this.repository = (Supplier)Preconditions.checkNotNull(repository, (Object)"Repository cannot be null!");
        this.repositoryID = (String)Preconditions.checkNotNull((Object)repositoryID, (Object)"Repository ID cannot be null!");
        this.isLocal = isLocal;
    }

    public Repository getRepository() {
        return this.repository.get();
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    @Deprecated
    public String getRepositoryName() {
        return this.repositoryID;
    }

    public List<Namespace> getNamespaces() {
        return (List)new WithConnection<List<Namespace>>(){

            @Override
            protected List<Namespace> doInConnection() {
                try {
                    return SemanticRepository.withCacheInRequest(NAMESPACES_ATTRIBUTE + "." + SemanticRepository.this.repositoryID, () -> Iterations.asList((CloseableIteration)this.connection.getNamespaces()));
                }
                catch (Exception e) {
                    LOG.error("Error while getting namespaces from the repository!", (Throwable)e);
                    return Collections.emptyList();
                }
            }
        }.run();
    }

    public List<RdfTypedResource> getContexts() {
        return this.getContexts(0, 0);
    }

    public static <R> R withCacheInRequest(String key, Callable<R> valueSupplier) throws Exception {
        if (RequestUtils.getRequest() == null) {
            return valueSupplier.call();
        }
        Object value = RequestUtils.getAttribute(key);
        if (value == null) {
            value = valueSupplier.call();
            RequestUtils.setAttribute(key, value);
        }
        return (R)value;
    }

    public RepositoryConnection getConnection() {
        try {
            return this.repository.get().getConnection();
        }
        catch (RepositoryException e) {
            LOG.error("Cannot get connection", (Throwable)e);
            return null;
        }
    }

    public void addNamespace(final String prefix, final String name) {
        new WithConnection<Void>(this){

            @Override
            protected Void doInConnection() throws RepositoryException {
                this.connection.begin();
                this.connection.setNamespace(prefix, name);
                this.connection.commit();
                return null;
            }
        }.run();
    }

    public void removeNamespace(final String namespace) {
        new WithConnection<Void>(this){

            @Override
            protected Void doInConnection() throws RepositoryException {
                this.connection.begin();
                this.connection.removeNamespace(namespace);
                this.connection.commit();
                return null;
            }
        }.run();
    }

    public void shutdown() {
    }

    public Map<IRI, Literal> getSysInfoMap() {
        return this.getSysInfoMapRemotely();
    }

    @Deprecated
    public Map<IRI, Literal> getSailRepositorySysInfoMap(Repository repository) {
        OwlimSchemaRepository schemaRepository;
        if (repository instanceof OwlimSchemaRepository) {
            schemaRepository = (OwlimSchemaRepository)repository;
        } else if (repository instanceof SailRepository) {
            schemaRepository = (OwlimSchemaRepository)((SailRepository)repository).getSail();
        } else {
            LOG.error("Could not get sysinfo map of '{}' sail repository", (Object)this.repositoryID);
            return null;
        }
        return schemaRepository.getSysInfoMap();
    }

    public Map<IRI, Literal> getSysInfoMapRemotely() {
        return (Map)new WithConnection<Map<IRI, Literal>>(){

            @Override
            protected Map<IRI, Literal> doInConnection() throws RepositoryException {
                HashMap sysInfoMap = Maps.newHashMap();
                try {
                    GraphQueryResult graphQueryResult = this.prepareAndEvaluateGraphQuery(SemanticRepository.SYSINFO_QUERY);
                    while (graphQueryResult.hasNext()) {
                        Statement next = (Statement)graphQueryResult.next();
                        IRI subject = (IRI)next.getSubject();
                        Literal object = (Literal)next.getObject();
                        sysInfoMap.put(subject, object);
                    }
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    LOG.error("Could not get sysinfo map of '{}' repository", (Object)SemanticRepository.this.repositoryID, (Object)e);
                }
                return sysInfoMap;
            }
        }.run();
    }

    public List<RdfTypedResource> getContexts(final Integer offset, final Integer size) {
        return (List)new WithConnection<List<RdfTypedResource>>(){

            @Override
            public List<RdfTypedResource> doInConnection() {
                try {
                    return SemanticRepository.withCacheInRequest(CONTEXTS_ATTRIBUTE + "." + SemanticRepository.this.repositoryID, () -> {
                        RepositoryResult contextIDs = this.connection.getContextIDs();
                        return SemanticRepository.getResourceForOffset((RepositoryResult<Resource>)contextIDs, offset, size);
                    });
                }
                catch (Exception e) {
                    LOG.error("Error while getting contexts from the repository!", (Throwable)e);
                    return Collections.emptyList();
                }
            }
        }.run();
    }

    @Nullable
    public String getNamespace(String prefix) {
        List<Namespace> namespaces = this.getNamespaces();
        for (Namespace ns : namespaces) {
            if (!ns.getPrefix().equals(prefix)) continue;
            return ns.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RdfTypedResource> getResourceForOffset(RepositoryResult<Resource> iterator, Integer offset, Integer size) {
        int skipped = 0;
        int added = 0;
        ArrayList<RdfTypedResource> resources = new ArrayList<RdfTypedResource>(size);
        size = size < 1 ? Integer.MAX_VALUE : size;
        try {
            while (iterator.hasNext() && added < size) {
                Resource resource = (Resource)iterator.next();
                if (skipped < offset) {
                    ++skipped;
                    continue;
                }
                RdfTypedResource typedResource = new RdfTypedResource();
                typedResource.setId(resource.stringValue());
                if (resource instanceof IRI) {
                    typedResource.setType("uri");
                } else if (resource instanceof BNode) {
                    typedResource.setType("bnode");
                }
                resources.add(typedResource);
                ++added;
            }
        }
        catch (RepositoryException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                iterator.close();
            }
            catch (RepositoryException e) {
                LOG.error("Couldn't close repository result!", (Throwable)e);
            }
        }
        return resources;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public abstract class WithConnection<R> {
        RepositoryConnection connection = null;
        List<QueryResult<?>> results = new ArrayList(4);

        public WithConnection() {
        }

        public WithConnection(RepositoryConnection repositoryConnection) {
            this.connection = repositoryConnection;
        }

        public R run() {
            try {
                this.connection = Optional.ofNullable(this.connection).orElse(SemanticRepository.this.getConnection());
                R r = this.doInConnection();
                return r;
            }
            catch (Exception e) {
                if (e instanceof GraphDBWorkbenchException) {
                    throw e;
                }
                throw new GraphDBWorkbenchException("There was an error while communicating with the repository", e);
            }
            finally {
                for (QueryResult<?> result : this.results) {
                    try {
                        result.close();
                    }
                    catch (QueryEvaluationException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (RepositoryException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        protected void begin() throws RepositoryException {
            this.connection.begin();
        }

        protected void commit() throws RepositoryException {
            this.connection.commit();
        }

        protected boolean prepareAndEvaluateBoolean(String q) throws MalformedQueryException, RepositoryException, QueryEvaluationException {
            return this.connection.prepareBooleanQuery(QueryLanguage.SPARQL, q).evaluate();
        }

        protected TupleQueryResult prepareAndEvaluate(String q) throws QueryEvaluationException, MalformedQueryException, RepositoryException {
            return this.prepareAndEvaluate(q, null);
        }

        protected TupleQueryResult prepareAndEvaluate(String q, Boolean includeInferred) throws QueryEvaluationException, MalformedQueryException, RepositoryException {
            return this.prepareAndEvaluate(q, includeInferred, 0);
        }

        protected TupleQueryResult prepareAndEvaluate(String q, int maxExecutionTimeout) throws QueryEvaluationException, MalformedQueryException, RepositoryException {
            return this.prepareAndEvaluate(q, null, maxExecutionTimeout);
        }

        protected TupleQueryResult prepareAndEvaluate(String q, Boolean includeInferred, int maxExecutionTime) throws QueryEvaluationException, MalformedQueryException, RepositoryException {
            TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, q);
            if (includeInferred != null) {
                query.setIncludeInferred(includeInferred.booleanValue());
            }
            if (maxExecutionTime > 0) {
                query.setMaxExecutionTime(maxExecutionTime);
            }
            TupleQueryResult result = query.evaluate();
            this.results.add((QueryResult<?>)result);
            return result;
        }

        protected TupleQuery prepare(String q) {
            return this.connection.prepareTupleQuery(QueryLanguage.SPARQL, q);
        }

        protected TupleQueryResult evaluate(TupleQuery query) {
            TupleQueryResult result = query.evaluate();
            this.results.add((QueryResult<?>)result);
            return result;
        }

        protected GraphQueryResult evaluate(GraphQuery query) {
            GraphQueryResult result = query.evaluate();
            this.results.add((QueryResult<?>)result);
            return result;
        }

        protected GraphQueryResult prepareAndEvaluateGraphQuery(String q) throws QueryEvaluationException, MalformedQueryException, RepositoryException {
            return this.prepareAndEvaluateGraphQuery(q, null, false);
        }

        protected GraphQueryResult prepareAndEvaluateGraphQuery(String q, Boolean includeInferred, Boolean sameAsState) throws QueryEvaluationException, MalformedQueryException, RepositoryException {
            GraphQuery query = this.connection.prepareGraphQuery(QueryLanguage.SPARQL, q);
            if (!sameAsState.booleanValue()) {
                SimpleDataset sample = new SimpleDataset();
                IRI onto_sameAs = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/disable-sameAs");
                sample.addNamedGraph(onto_sameAs);
                query.setDataset((Dataset)sample);
            }
            if (includeInferred != null) {
                query.setIncludeInferred(includeInferred.booleanValue());
            }
            GraphQueryResult result = query.evaluate();
            this.results.add((QueryResult<?>)result);
            return result;
        }

        protected void prepareAndExecuteUpdate(String u) throws MalformedQueryException, RepositoryException, UpdateExecutionException {
            this.connection.prepareUpdate(QueryLanguage.SPARQL, u).execute();
        }

        protected abstract R doInConnection() throws RepositoryException;
    }

    public abstract class WithRawConnection<R> {
        public R run() {
            RepositoryConnection connection = null;
            try {
                connection = SemanticRepository.this.getConnection();
                R r = this.doInConnection(connection);
                return r;
            }
            catch (RepositoryException e) {
                throw new RuntimeException("There was an error while communicating with the repository", e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (RepositoryException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        protected abstract R doInConnection(RepositoryConnection var1) throws RepositoryException;
    }
}

