/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic.repository;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public abstract class RepositoryIdChangedListener
implements ApplicationListener<PropertyChangedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryIdChangedListener.class);

    public void onApplicationEvent(PropertyChangedEvent propertyChangedEvent) {
        if (propertyChangedEvent.getKey().equals("repository.id.changed")) {
            try {
                this.updateAfterChangedRepoId((String)propertyChangedEvent.getSource(), propertyChangedEvent.getValue());
            }
            catch (GraphDBWorkbenchException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract void updateAfterChangedRepoId(String var1, String var2) throws GraphDBWorkbenchException;
}

