/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic.location;

import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.semantic.LLMUpdateProcessor;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.core.semantic.location.LocationUpdate;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.graphdb.security.AuthType;
import com.ontotext.raft.update.ExternalUpdateProcessor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.springframework.context.ApplicationEvent;

public class SemanticUpdateProcessor
implements ExternalUpdateProcessor {
    private final SemanticLocationManagement locationManagement;
    private final SemanticDataManagement semanticDataManagement;
    private LLMUpdateProcessor llmUpdateProcessor;

    public SemanticUpdateProcessor(SemanticLocationManagement locationManagement, SemanticDataManagement dataManagement) {
        this.locationManagement = locationManagement;
        this.semanticDataManagement = dataManagement;
    }

    public void setLlmUpdateProcessor(LLMUpdateProcessor llmUpdateProcessor) {
        this.llmUpdateProcessor = llmUpdateProcessor;
    }

    public String processLocationUpdate(DataInputStream configStream) throws IOException {
        String fingerprint = this.readString(configStream);
        String location = this.readString(configStream);
        LocationUpdate.OperationType operationType = LocationUpdate.OperationType.valueOf(this.readString(configStream));
        if (LocationUpdate.OperationType.DELETE.equals((Object)operationType)) {
            this.semanticDataManagement.publishLocationEvent(location, "semantic.location.removed");
            this.locationManagement.removeLocation(location);
            return fingerprint;
        }
        AuthType authType = AuthType.valueOf((String)this.readString(configStream));
        LocationType locationType = LocationType.valueOf(this.readString(configStream));
        String username = this.readString(configStream);
        String password = this.readString(configStream);
        String defaultRepo = this.readString(configStream);
        if (StringUtils.isEmpty((CharSequence)defaultRepo)) {
            defaultRepo = null;
        }
        if (LocationUpdate.OperationType.ADD.equals((Object)operationType)) {
            try {
                this.locationManagement.addLocation(location, authType, locationType, username, password, defaultRepo);
                this.semanticDataManagement.publishLocationEvent(location, "semantic.location.changed");
            }
            catch (URISyntaxException e) {
                throw new UpdateExecutionException("Unable to process system update", (Throwable)e);
            }
        }
        if (LocationUpdate.OperationType.UPDATE.equals((Object)operationType)) {
            SemanticLocationAuth existingLocation = this.locationManagement.getExistingLocation(location);
            if (existingLocation == null) {
                throw new UpdateExecutionException("Location not found: " + location);
            }
            existingLocation.setUsername(username);
            existingLocation.setPassword(password);
            existingLocation.setAuthType(authType);
            existingLocation.setLocationType(locationType);
            existingLocation.setDefaultRepository(defaultRepo);
            existingLocation.updateRequestAuthenticator();
            this.semanticDataManagement.publishLocationEvent(location, "semantic.location.changed");
        }
        return fingerprint;
    }

    public String deleteUser(DataInputStream configStream) throws IOException {
        String fingerprint = this.readString(configStream);
        this.locationManagement.getAccountsService().deleteInCluster(this.readString(configStream));
        return fingerprint;
    }

    public String addUser(DataInputStream configStream) throws IOException {
        String fingerprint = this.readString(configStream);
        Account acc = (Account)SemanticUpdateProcessor.objectFromStream(configStream);
        this.locationManagement.getAccountsService().addNewUserInCluster(acc);
        return fingerprint;
    }

    public String editUser(DataInputStream configStream) throws IOException {
        String fingerprint = this.readString(configStream);
        Account acc = (Account)SemanticUpdateProcessor.objectFromStream(configStream);
        Boolean editPass = (Boolean)SemanticUpdateProcessor.objectFromStream(configStream);
        this.locationManagement.getAccountsService().editUserAccountInCluster(acc, editPass);
        return fingerprint;
    }

    public String updateSecurityProperty(DataInputStream configStream) throws IOException {
        String fingerprint = this.readString(configStream);
        String key = this.readString(configStream);
        Object val = SemanticUpdateProcessor.objectFromStream(configStream);
        this.locationManagement.getAccountsService().changeSecurityConfig(key, val);
        return fingerprint;
    }

    public String updateVisualGraph(DataInputStream configStream) throws IOException {
        String fingerprint = this.readString(configStream);
        this.locationManagement.getAccountsService().handleEventInCluster((ApplicationEvent)SemanticUpdateProcessor.objectFromStream(configStream));
        return fingerprint;
    }

    public String updateSavedQuery(DataInputStream configStream) throws IOException {
        String fingerprint = this.readString(configStream);
        this.locationManagement.getAccountsService().handleEventInCluster((ApplicationEvent)SemanticUpdateProcessor.objectFromStream(configStream));
        return fingerprint;
    }

    public String updateSavedGraph(DataInputStream configStream) throws IOException {
        String fingerprint = this.readString(configStream);
        this.locationManagement.getAccountsService().handleEventInCluster((ApplicationEvent)SemanticUpdateProcessor.objectFromStream(configStream));
        return fingerprint;
    }

    public String restartRepository(DataInputStream configStream) throws IOException, InterruptedException {
        String fingerprint = this.readString(configStream);
        SemanticLocation currentLocation = this.semanticDataManagement.getCurrentLocation();
        GraphDBRepositoryManager repositoryManager = (GraphDBRepositoryManager)currentLocation.sesameManager();
        currentLocation.getRestartingThread(this.readString(configStream), repositoryManager).join();
        return fingerprint;
    }

    public String processAgentUpdate(DataInputStream configStream) throws IOException {
        return this.llmUpdateProcessor.processAgentUpdate(configStream);
    }

    public String processAgentDelete(DataInputStream configStream) throws IOException {
        return this.llmUpdateProcessor.processAgentDelete(configStream);
    }

    public String processConversationUpdate(DataInputStream configStream) throws IOException {
        return this.llmUpdateProcessor.processConversationUpdate(configStream);
    }

    public String processConversationDelete(DataInputStream configStream) throws IOException {
        return this.llmUpdateProcessor.processConversationDelete(configStream);
    }

    private String readString(DataInputStream configStream) throws IOException {
        int size = configStream.readInt();
        byte[] stringBytes = new byte[size];
        configStream.read(stringBytes);
        return new String(stringBytes, StandardCharsets.UTF_8);
    }

    public static Object objectFromStream(DataInputStream inputStream) {
        Object object;
        ObjectInputStream objectStream = new ObjectInputStream(new ByteArrayInputStream(inputStream.readNBytes(inputStream.readInt())));
        try {
            object = objectStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        objectStream.close();
        return object;
    }
}

