/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.semantic.repository.SemanticRepositoryFactory;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;

class StringSemanticRepositoryCacheLoader
extends CacheLoader<String, SemanticRepository> {
    private final RepositoryManager repositoryManager;
    private final SemanticRepositoryFactory repositoryFactory;
    private final boolean isLocal;

    public StringSemanticRepositoryCacheLoader(RepositoryManager repositoryManager, SemanticRepositoryFactory repositoryFactory, boolean isLocal) {
        this.repositoryManager = repositoryManager;
        this.repositoryFactory = repositoryFactory;
        this.isLocal = isLocal;
    }

    public SemanticRepository load(String repositoryId) throws Exception {
        Preconditions.checkState((boolean)this.repositoryManager.hasRepositoryConfig(repositoryId), (Object)("Repository " + repositoryId + " doesn't exist!"));
        return this.repositoryFactory.getSemanticRepository(() -> this.repositoryManager.getRepository(repositoryId), repositoryId, this.isLocal);
    }
}

