/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SparqlService {
    private static final Logger LOG = LoggerFactory.getLogger(SparqlService.class);

    public String readQueryString(String fileName) throws IOException {
        return IOUtil.readString((InputStream)this.getClass().getResourceAsStream("/" + fileName + ".sparql"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getResultsForAllQueryBindings(TupleQueryResult tqr) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        String currentBinding = null;
        try {
            List bindings = tqr.getBindingNames();
            for (String binding : bindings) {
                resultMap.put(binding, new ArrayList());
            }
            while (tqr.hasNext()) {
                BindingSet bs = (BindingSet)tqr.next();
                for (Map.Entry entry : resultMap.entrySet()) {
                    currentBinding = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    Value value = bs.getValue(currentBinding);
                    if (value == null) continue;
                    values.add(value.stringValue());
                }
            }
        }
        catch (QueryEvaluationException e) {
            LOG.error("Failed to get results for binding ?{}. Query results corrupted?!", currentBinding);
        }
        finally {
            this.closeQueryResult(tqr);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getFlattenedResultsForAllQueryBindings(TupleQueryResult tqr) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        try {
            List bindingNames = tqr.getBindingNames();
            while (tqr.hasNext()) {
                ArrayList<String> bindingValues = new ArrayList<String>(bindingNames.size());
                BindingSet bs = (BindingSet)tqr.next();
                for (String bindingName : bindingNames) {
                    String bindingValue = null;
                    Binding b = bs.getBinding(bindingName);
                    if (b != null) {
                        Value value = b.getValue();
                        if (value == null) continue;
                        bindingValue = value.stringValue();
                    }
                    bindingValues.add(bindingValue);
                }
                result.add(bindingValues);
            }
        }
        catch (QueryEvaluationException e) {
            LOG.error("Failed to get results.");
        }
        finally {
            this.closeQueryResult(tqr);
        }
        return result;
    }

    private void closeQueryResult(TupleQueryResult tqr) {
        try {
            tqr.close();
        }
        catch (QueryEvaluationException e) {
            LOG.error("Error closing tuple query result!");
        }
    }
}

