/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.LLMUpdateProcessor;
import com.ontotext.forest.core.semantic.LastRunSemanticStateHelper;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.location.OntopicSemanticRepositoryLocation;
import com.ontotext.forest.core.semantic.location.SPARQLEndpointLocation;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.forest.core.semantic.location.SemanticUpdateProcessor;
import com.ontotext.forest.core.semantic.repository.SemanticRepositoryFactory;
import com.ontotext.forest.core.semantic.rpc.GraphDBRpcServer;
import com.ontotext.forest.core.util.BeanServerRecoveryListener;
import com.ontotext.forest.core.util.RequestUtils;
import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.graphdb.FederatedServiceAuthenticationResolver;
import com.ontotext.graphdb.GraphDBRepositoryAccessChecker;
import com.ontotext.graphdb.security.AuthType;
import com.ontotext.graphdb.security.LocationAuth;
import com.ontotext.graphdb.security.LocationAuthProvider;
import com.ontotext.graphdb.security.TokenManager;
import com.ontotext.raft.config.ClusterConfigService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class SemanticLocationManagement
implements LocationAuthProvider {
    public static final String ERROR_USERNAME_REQUIRED = "Username is required to access the remote SPARQL endpoint.";
    public static final String ERROR_PASSWORD_REQUIRED = "Password is required to access the remote SPARQL endpoint.";
    public static final String ERROR_CLIENT_ID_REQUIRED = "Client ID could not be empty for remote Ontopic instance.";
    public static final String ERROR_SECRET_REQUIRED = "Secret could not be empty for remote Ontopic instance.";
    private final Cache<String, SemanticLocationAuth> locationToSemanticLocation = CacheBuilder.newBuilder().build();
    private SemanticUpdateProcessor semanticUpdateProcessor;
    private volatile AccountsService accountsService;
    @Autowired
    private LastRunSemanticStateHelper lastRunSemanticStateHelper;
    @Autowired
    private SemanticDataManagement dataManagement;
    @Autowired
    private GraphDBRpcServer rpcServer;
    @Autowired
    private SemanticRepositoryFactory repositoryFactory;
    @Autowired(required=false)
    private GraphDBRepositoryAccessChecker repositoryAccessChecker;
    @Autowired
    private ResourceUtils resourceUtils;
    @Autowired
    private BeanFactory beanFactory;
    private final String uniqueLocationId = UUID.randomUUID().toString();
    private final LocationFederatedServiceAuthenticationResolver serviceAuthenticationResolver = new LocationFederatedServiceAuthenticationResolver();

    @PostConstruct
    public void init() {
        TokenManager.getInstance().setLocationAuthProvider((LocationAuthProvider)this);
        this.semanticUpdateProcessor = new SemanticUpdateProcessor(this, this.dataManagement);
    }

    public String getUniqueLocationId() {
        return this.uniqueLocationId;
    }

    public void setAccountsService(AccountsService accountsService) {
        this.accountsService = accountsService;
    }

    public AccountsService getAccountsService() {
        return this.accountsService;
    }

    public void setLLMProcessor(LLMUpdateProcessor llmUpdateProcessor) {
        this.semanticUpdateProcessor.setLlmUpdateProcessor(llmUpdateProcessor);
    }

    public SemanticLocationAuth addLocation(String location, AuthType authType, LocationType locationType, @Nullable String username, @Nullable String password, @Nullable String defaultRepository) throws URISyntaxException {
        if (LocationType.GDB.equals((Object)locationType) || locationType == null) {
            return this.addRepositoryLocation(location, authType, username, password, defaultRepository);
        }
        if (LocationType.ONTOPIC.equals((Object)locationType)) {
            return this.addOntopicLocation(location, username, password);
        }
        if (LocationType.SPARQL.equals((Object)locationType)) {
            return this.addSPARQLLocation(location, username, password);
        }
        throw new UnsupportedOperationException(String.format("Unknown location type {}", locationType.name()));
    }

    public OntopicSemanticRepositoryLocation addOntopicLocation(String location, @Nullable String username, @Nullable String password) {
        this.validateInputParameters(location, username, password, LocationType.ONTOPIC);
        location = this.removeEndingSlash(location);
        OntopicSemanticRepositoryLocation ifPresent = (OntopicSemanticRepositoryLocation)this.getExistingLocation(location);
        if (ifPresent != null) {
            return ifPresent;
        }
        OntopicSemanticRepositoryLocation ontopicSemanticRepositoryLocation = new OntopicSemanticRepositoryLocation(location, username, password);
        this.locationToSemanticLocation.put((Object)location, (Object)ontopicSemanticRepositoryLocation);
        return ontopicSemanticRepositoryLocation;
    }

    public SPARQLEndpointLocation addSPARQLLocation(String location, @Nullable String username, @Nullable String password) {
        this.validateInputParameters(location, username, password, LocationType.SPARQL);
        location = this.removeEndingSlash(location);
        SPARQLEndpointLocation ifPresent = (SPARQLEndpointLocation)this.getExistingLocation(location);
        if (ifPresent != null) {
            return ifPresent;
        }
        SPARQLEndpointLocation sparqlEndpointLocation = new SPARQLEndpointLocation(location, username, password);
        this.locationToSemanticLocation.put((Object)location, (Object)sparqlEndpointLocation);
        return sparqlEndpointLocation;
    }

    @Nonnull
    public SemanticLocation addRepositoryLocation(String location, AuthType authType, @Nullable String username, @Nullable String password, @Nullable String defaultRepository) throws URISyntaxException, RepositoryException, GraphDBWorkbenchException {
        SemanticLocation ifPresent = (SemanticLocation)this.getExistingLocation(location = this.validateLocationString(location));
        if (ifPresent != null) {
            return ifPresent;
        }
        SemanticLocation semanticLocation = new SemanticLocation(this.repositoryFactory, location, authType, LocationType.GDB, username, password, defaultRepository, this.getUniqueLocationId(), this.repositoryAccessChecker, this.rpcServer::getRpcServer, this.getClusterConfigService(), this.getServerRecoveryListener(), this.getServiceAuthenticationResolver(), this.semanticUpdateProcessor);
        semanticLocation.setMaxConnections((Integer)this.resourceUtils.getNewOrDeprecatedProperty("graphdb.workbench.maxConnections", "app.maxConnections"));
        this.locationToSemanticLocation.put((Object)location, (Object)semanticLocation);
        return semanticLocation;
    }

    @NotNull
    private String validateLocationString(String location) {
        if (!location.isEmpty()) {
            File file = new File(location);
            if (!file.isAbsolute()) {
                try {
                    new URL(location);
                    if (!location.startsWith("http") && !location.startsWith("file:/")) {
                        throw new IllegalArgumentException(location + " is not a valid location. We accept http(s) URLs");
                    }
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(location + " is not a valid location. We accept http(s) URLs");
                }
            }
            location = this.removeEndingSlash(location);
        }
        return location;
    }

    @Nonnull
    public SemanticLocation getSystemLocation() throws URISyntaxException, RepositoryException, GraphDBWorkbenchException {
        String location = "";
        SemanticLocationAuth ifPresent = this.getExistingLocation("");
        if (ifPresent != null && ifPresent instanceof SemanticLocation) {
            return (SemanticLocation)ifPresent;
        }
        SemanticLocation semanticLocation = new SemanticLocation(this.repositoryFactory, location, AuthType.NONE, LocationType.GDB, null, null, null, this.getUniqueLocationId(), this.repositoryAccessChecker, this.rpcServer::getRpcServer, this.getClusterConfigService(), this.getServerRecoveryListener(), this.getServiceAuthenticationResolver(), this.semanticUpdateProcessor);
        this.locationToSemanticLocation.put((Object)location, (Object)semanticLocation);
        return semanticLocation;
    }

    @NotNull
    private BeanServerRecoveryListener getServerRecoveryListener() {
        return new BeanServerRecoveryListener(this.beanFactory);
    }

    @NotNull
    protected FederatedServiceAuthenticationResolver getServiceAuthenticationResolver() {
        return this.serviceAuthenticationResolver;
    }

    public void removeLocation(String location) throws RepositoryException {
        SemanticLocationAuth semanticLocationAuth = this.getExistingLocation(location);
        this.locationToSemanticLocation.invalidate((Object)location);
        if (semanticLocationAuth != null) {
            this.dataManagement.locationRemoved(semanticLocationAuth);
            semanticLocationAuth.close();
        }
    }

    @Nonnull
    public List<String> getLocationURIs() {
        return new ArrayList<String>(this.locationToSemanticLocation.asMap().keySet());
    }

    public Collection<SemanticLocationAuth> getLocations() {
        return this.locationToSemanticLocation.asMap().values();
    }

    public Collection<SemanticLocation> getRepositoryLocations() {
        return this.locationToSemanticLocation.asMap().values().stream().filter(l -> l instanceof SemanticLocation).map(l -> (SemanticLocation)l).collect(Collectors.toList());
    }

    @Nullable
    public SemanticLocationAuth getExistingLocation(String selectLocation) {
        this.lastRunSemanticStateHelper.initLocationAndRepositoryOnce(RequestUtils.getRequest());
        selectLocation = this.removeEndingSlash(selectLocation);
        return (SemanticLocationAuth)this.locationToSemanticLocation.getIfPresent((Object)selectLocation);
    }

    @Nonnull
    public SemanticLocationAuth getExistingLocationOrThrow(String selectLocation) {
        SemanticLocationAuth semanticLocation = this.getExistingLocation(selectLocation);
        if (semanticLocation == null) {
            throw new IllegalStateException("Location " + selectLocation + " is not attached.");
        }
        return semanticLocation;
    }

    private String removeEndingSlash(String selectLocation) {
        if (selectLocation.endsWith("/")) {
            selectLocation = selectLocation.substring(0, selectLocation.length() - 1);
        }
        return selectLocation;
    }

    public LocationAuth getAuthForLocation(String selectLocation) {
        SemanticLocationAuth existingLocation = this.getExistingLocation(selectLocation);
        if (existingLocation != null) {
            return new LocationAuth(existingLocation.getUsername(), existingLocation.getPassword(), existingLocation.getAuthType());
        }
        return null;
    }

    public ClusterConfigService getClusterConfigService() {
        return ClusterConfigService.defaultService();
    }

    @VisibleForTesting
    public void invalidateCache() {
        this.locationToSemanticLocation.invalidateAll();
    }

    private void validateInputParameters(String location, @Nullable String username, @Nullable String password, LocationType locationType) {
        if (!location.startsWith("http")) {
            throw new IllegalArgumentException(location + " is not a valid " + String.valueOf((Object)locationType) + " location. We accept http(s) URLs");
        }
        if (StringUtils.isEmpty((CharSequence)username)) {
            throw new IllegalArgumentException(locationType == LocationType.ONTOPIC ? ERROR_CLIENT_ID_REQUIRED : ERROR_USERNAME_REQUIRED);
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException(locationType == LocationType.ONTOPIC ? ERROR_SECRET_REQUIRED : ERROR_PASSWORD_REQUIRED);
        }
    }

    private class LocationFederatedServiceAuthenticationResolver
    implements FederatedServiceAuthenticationResolver {
        private final String repositoriesPath = "/repositories/";
        private final int repositoriesPathLength = "/repositories/".length();

        private LocationFederatedServiceAuthenticationResolver() {
        }

        public void authorizeRequest(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            SemanticLocationAuth location;
            String url = this.getRequestUrl(httpRequest);
            if (url != null && (location = this.getLocationFromUrl(url)) != null) {
                if (location instanceof SemanticLocation) {
                    SemanticLocation srl = (SemanticLocation)location;
                    String repositoryId = this.getRepositoryId(url);
                    if (srl.getRepositoryAccessChecker().hasAccess(this.getRepositoryIdForAccessCheck(srl, repositoryId), false)) {
                        srl.getRequestAuthenticator().process(httpRequest, httpContext);
                    }
                } else {
                    location.getRequestAuthenticator().process(httpRequest, httpContext);
                }
            }
        }

        public boolean isOntopicLocation(String requestUrl) {
            SemanticLocationAuth location = this.getLocationFromUrl(this.removeRequestParams(requestUrl));
            if (location != null) {
                return location.getLocationType() == LocationType.ONTOPIC;
            }
            return false;
        }

        private String getRequestUrl(HttpRequest httpRequest) {
            String url = null;
            if (httpRequest instanceof HttpRequestWrapper) {
                url = ((HttpRequestWrapper)httpRequest).getOriginal().getRequestLine().getUri();
                url = this.removeRequestParams(url);
            }
            return url;
        }

        private String removeRequestParams(String url) {
            int indexOfQuery = url.indexOf(63);
            if (indexOfQuery > 0) {
                url = url.substring(0, indexOfQuery);
            }
            return url;
        }

        @Nullable
        private SemanticLocationAuth getLocationFromUrl(String requestUrl) throws RepositoryException {
            SemanticLocationManagement.this.lastRunSemanticStateHelper.initLocationAndRepositoryOnce(RequestUtils.getRequest());
            for (Map.Entry entry : SemanticLocationManagement.this.locationToSemanticLocation.asMap().entrySet()) {
                String location = (String)entry.getKey();
                SemanticLocationAuth semanticLocation = (SemanticLocationAuth)entry.getValue();
                if (location.isEmpty() || !requestUrl.startsWith(location) || semanticLocation.isLocal()) continue;
                return semanticLocation;
            }
            return null;
        }

        private String getRepositoryId(String url) {
            String repositoryId = null;
            int index = url.indexOf("/repositories/");
            if (index > 0 && (index = (repositoryId = url.substring(index + this.repositoriesPathLength)).indexOf(47)) > 0) {
                repositoryId = repositoryId.substring(0, index);
            }
            return repositoryId;
        }

        private String getRepositoryIdForAccessCheck(SemanticLocation location, @Nullable String repositoryId) {
            return repositoryId + "@" + location.getLocation();
        }
    }
}

