/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class StaticContext {
    private StaticApplicationContext ctx = new StaticApplicationContext();

    private StaticContext() {
    }

    public static StaticContext create() {
        return new StaticContext();
    }

    public ApplicationContext build() {
        this.ctx.refresh();
        return this.ctx;
    }

    public BeanContext bean(String name, Class<?> beanClass) {
        return new BeanContext(name, beanClass);
    }

    public class BeanContext {
        private String name;
        private Class<?> beanClass;
        private ConstructorArgumentValues args;
        private MutablePropertyValues props;

        private BeanContext(String name, Class<?> beanClass) {
            this.name = name;
            this.beanClass = beanClass;
            this.args = new ConstructorArgumentValues();
            this.props = new MutablePropertyValues();
        }

        public BeanContext arg(Object arg) {
            this.args.addGenericArgumentValue(arg);
            return this;
        }

        public BeanContext arg(int index, Object arg) {
            this.args.addIndexedArgumentValue(index, arg);
            return this;
        }

        public BeanContext prop(String name, Object value) {
            this.props.add(name, value);
            return this;
        }

        public BeanContext ref(String name, String beanRef) {
            this.props.add(name, (Object)new RuntimeBeanReference(beanRef));
            return this;
        }

        public void build() {
            RootBeanDefinition def = new RootBeanDefinition(this.beanClass, this.args, this.props);
            StaticContext.this.ctx.registerBeanDefinition(this.name, (BeanDefinition)def);
        }
    }
}

