/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import com.ontotext.forest.core.error.ErrorMessage;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.graphdb.security.InvalidACLValueException;
import com.ontotext.graphdb.security.acl.AccessControlException;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.sail.shacl.GraphDBShaclSailValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class ForestErrorController {
    private final Logger logger = LoggerFactory.getLogger(ForestErrorController.class);

    @ExceptionHandler(value={RepositoryConfigException.class})
    public ResponseEntity<ErrorMessage> handleRepositoryConfigurationException(Exception ex, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage("Invalid GraphDB configuration."), (HttpStatusCode)HttpStatus.BAD_REQUEST), response, ex);
    }

    @ExceptionHandler(value={UnsupportedRDFormatException.class, RDFParseException.class})
    public ResponseEntity<ErrorMessage> handleRDFException(Exception ex, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage("Invalid RDF format and/or content."), (HttpStatusCode)HttpStatus.BAD_REQUEST), response, ex);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<ErrorMessage> handleNotFound(Exception ex, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage(ex.getMessage()), (HttpStatusCode)HttpStatus.NOT_FOUND), response, ex);
    }

    @ExceptionHandler(value={GraphDBWorkbenchException.class})
    public ResponseEntity<ErrorMessage> handleGraphDBWorkbenchException(Exception ex, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage(ex.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST), response, ex);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ErrorMessage> handleAccessDeniedException(Exception ex, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage(ex.getMessage()), (HttpStatusCode)HttpStatus.FORBIDDEN), response, ex);
    }

    @ExceptionHandler(value={AccessControlException.class})
    public ResponseEntity<ErrorMessage> handleAccessControlException(Exception ex, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage(ex.getMessage()), (HttpStatusCode)HttpStatus.FORBIDDEN), response, ex);
    }

    @ExceptionHandler(value={GraphDBShaclSailValidationException.class})
    public ResponseEntity<ErrorMessage> handleGraphDBShaclSailValidationException(GraphDBShaclSailValidationException ex, HttpServletRequest request, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage(ex.writeShaclValidationReportInRequestedMimetype(request)), (HttpStatusCode)HttpStatus.BAD_REQUEST), response, (Exception)ex);
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<ErrorMessage> handleGeneric(Exception ex, HttpServletResponse response) {
        if (response.getContentType() != null && response.getContentType().toLowerCase().startsWith("text/event-stream")) {
            this.logger.debug("SSE client disconnected or error occurred, skipping error body");
            response.setStatus(200);
            try {
                response.getOutputStream().close();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close SSE output stream", (Throwable)e);
            }
            return null;
        }
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage(Objects.toString(ex.getMessage(), ex.getClass().toString())), (HttpStatusCode)this.getStatusGeneric(ex)), response, ex);
    }

    @ExceptionHandler(value={HTTPException.class})
    public void handleRdf4jHTTP(HTTPException ex, HttpServletResponse response) throws IOException {
        if (!ForestErrorController.forceCloseSocketIfCommitted(response, (Throwable)ex, this.logger)) {
            response.sendError(ex.getStatusCode(), ex.getMessage());
        }
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ErrorMessage> handleHttpMessageNotReadableException(HttpMessageNotReadableException ex, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)this.getErrorMessageHttpMessageNotReadableException(ex), (HttpStatusCode)HttpStatus.BAD_REQUEST), response, (Exception)ex);
    }

    @ExceptionHandler(value={InvalidACLValueException.class})
    public ResponseEntity<ErrorMessage> handleHttpMessageNotReadableException(InvalidACLValueException ex, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage(ex.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST), response, (Exception)ex);
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public ResponseEntity<ErrorMessage> handleResponseStatusException(ResponseStatusException ex, HttpServletResponse response) {
        return this.handleExceptionOrCloseSocket(() -> new ResponseEntity((Object)new ErrorMessage(ex.getReason()), ex.getStatusCode()), response, (Exception)ex);
    }

    private ResponseEntity<ErrorMessage> handleExceptionOrCloseSocket(Supplier<ResponseEntity<ErrorMessage>> handler, HttpServletResponse response, Exception error) {
        if (ForestErrorController.forceCloseSocketIfCommitted(response, error, this.logger)) {
            return null;
        }
        return handler.get();
    }

    public static boolean forceCloseSocketIfCommitted(HttpServletResponse response, Throwable error, Logger logger) {
        if (response.isCommitted()) {
            Object sc;
            Object socket;
            Object socketWrapper;
            Object hook;
            Object coyoteResponse;
            Object connectorResponse = null;
            if (response instanceof ServletResponseWrapper) {
                Object entry1 = ForestErrorController.getFieldValue("response", response, true, true);
                connectorResponse = ForestErrorController.getFieldValue("response", entry1, false);
            } else {
                connectorResponse = ForestErrorController.getFieldValue("response", response, false);
            }
            if (connectorResponse != null && (coyoteResponse = ForestErrorController.getFieldValue("coyoteResponse", connectorResponse, false)) != null && (hook = ForestErrorController.getFieldValue("hook", coyoteResponse, false)) != null && (socketWrapper = ForestErrorController.getFieldValue("socketWrapper", hook, true)) != null && (socket = ForestErrorController.getFieldValue("socket", socketWrapper, true)) != null && (sc = ForestErrorController.getFieldValue("sc", socket, false)) != null && sc instanceof SocketChannel) {
                try {
                    ((SocketChannel)sc).setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)0);
                    ((SocketChannel)sc).close();
                    logger.warn("Error after HTTP response was committed, closing HTTP connection:", error);
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static Object getFieldValue(String fieldName, Object instance, boolean superclass) {
        return ForestErrorController.getFieldValue(fieldName, instance, superclass, false);
    }

    private static Object getFieldValue(String fieldName, Object instance, boolean superclass, boolean supersuperclass) {
        try {
            Class<?> clazz = instance.getClass();
            if (superclass) {
                clazz = clazz.getSuperclass();
            }
            if (supersuperclass) {
                clazz = clazz.getSuperclass();
            }
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private HttpStatus getStatusGeneric(Throwable throwable) {
        Throwable cause = throwable;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof AccessControlException) {
            return HttpStatus.FORBIDDEN;
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private ErrorMessage getErrorMessageHttpMessageNotReadableException(HttpMessageNotReadableException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof JsonMappingException) {
            Throwable innerCause = cause.getCause();
            if (innerCause instanceof InvalidACLValueException) {
                JsonMappingException.Reference listReference;
                ImmutableMap details = null;
                List path = ((JsonMappingException)cause).getPath();
                if (path.size() == 2 && (listReference = (JsonMappingException.Reference)path.get(0)).getFrom() instanceof List) {
                    JsonMappingException.Reference fieldReference = (JsonMappingException.Reference)path.get(1);
                    details = ImmutableMap.of((Object)"index", (Object)listReference.getIndex(), (Object)"field", (Object)fieldReference.getFieldName());
                }
                return new ErrorMessage(innerCause.getMessage(), (Map<String, ?>)details);
            }
            if (innerCause instanceof IllegalArgumentException) {
                return new ErrorMessage(innerCause.getMessage());
            }
            if (innerCause instanceof JsonParseException) {
                return new ErrorMessage(innerCause.getMessage());
            }
        }
        return new ErrorMessage(exception.getMessage());
    }
}

