/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.opensearch.util;

import com.ontotext.trree.plugin.externalsync.impl.embedding.EmbeddingModelUtil;
import com.ontotext.trree.plugin.externalsync.impl.embedding.VectorBuilder;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;

public class StringToVectorDeserializer
implements JsonpDeserializer<List<Float>> {
    public static final JsonpDeserializer<List<Float>> FLOAT_LIST_DESERIALIZER = JsonpDeserializer.arrayDeserializer((JsonpDeserializer)JsonpDeserializer.floatDeserializer());
    public static final JsonpDeserializer<String> STRING_DESERIALIZER = JsonpDeserializer.stringDeserializer();
    private VectorBuilder vectorBuilder;

    public EnumSet<JsonParser.Event> nativeEvents() {
        return FLOAT_LIST_DESERIALIZER.nativeEvents();
    }

    public EnumSet<JsonParser.Event> acceptedEvents() {
        return FLOAT_LIST_DESERIALIZER.acceptedEvents();
    }

    public List<Float> deserialize(JsonParser jsonParser, JsonpMapper jsonpMapper, JsonParser.Event event) {
        if (event == JsonParser.Event.VALUE_STRING) {
            String text = (String)STRING_DESERIALIZER.deserialize(jsonParser, jsonpMapper, event);
            if (this.vectorBuilder == null) {
                EmbeddingModelUtil.throwNoProvidedEmbeddingModelImplementation();
            }
            float[] vector = this.vectorBuilder.embeddingFromText(text).vector();
            return IntStream.range(0, vector.length).mapToObj(i -> Float.valueOf(vector[i])).collect(Collectors.toList());
        }
        return (List)FLOAT_LIST_DESERIALIZER.deserialize(jsonParser, jsonpMapper, event);
    }

    public void setVectorBuilder(VectorBuilder vectorBuilder) {
        this.vectorBuilder = vectorBuilder;
    }
}

