/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.opensearch;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.ValidatorWithPlugin;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.OpensearchDriver;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpensearchUrlValidation
implements ValidatorWithPlugin<String> {
    private static final Logger LOG = LoggerFactory.getLogger(OpensearchUrlValidation.class);
    public static final String COULD_NOT_CONNECT_TO_OPENSEARCH_MSG = "Couldn't connect to OpenSearch at ";

    @Nullable
    public String validate(ExternalSyncPlugin plugin, @Nullable String nodes, Options optionsSet) {
        assert (nodes != null);
        if (plugin.isTestingTransaction()) {
            try {
                String canConnectToOpensearch = OpensearchDriver.canConnectToOpensearch(optionsSet, LOG);
                if (canConnectToOpensearch != null) {
                    return COULD_NOT_CONNECT_TO_OPENSEARCH_MSG + nodes + "! " + canConnectToOpensearch;
                }
            }
            catch (Exception ex) {
                LOG.error(COULD_NOT_CONNECT_TO_OPENSEARCH_MSG + nodes, (Throwable)ex);
                return COULD_NOT_CONNECT_TO_OPENSEARCH_MSG + nodes + "! " + ex.getMessage();
            }
        }
        return null;
    }

    @Nullable
    public Object validate(@Nullable String value, Options optionsSet) {
        throw new IllegalStateException("Plugin required. Use the other method to validate.");
    }
}

