/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.opensearch;

import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.api.DocumentsResult;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.Facet;
import com.ontotext.trree.plugin.externalsync.api.FlexibleBucket;
import com.ontotext.trree.plugin.externalsync.api.FlexibleBucketItem;
import com.ontotext.trree.plugin.externalsync.impl.AbstractExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.OpensearchDriver;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.OpensearchResult;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.OpensearchStore;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.ClassLoaderUtil;
import com.ontotext.trree.plugin.externalsync.util.ValuesUtil;
import com.ontotext.trree.sdk.Entities;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramAggregate;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramBucket;
import org.opensearch.client.opensearch._types.aggregations.DoubleTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.HistogramAggregate;
import org.opensearch.client.opensearch._types.aggregations.HistogramBucket;
import org.opensearch.client.opensearch._types.aggregations.LongTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketBase;
import org.opensearch.client.opensearch._types.aggregations.RangeAggregate;
import org.opensearch.client.opensearch._types.aggregations.RangeBucket;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregateBase;
import org.opensearch.client.opensearch._types.aggregations.TermsBucketBase;
import org.slf4j.Logger;

public class OpensearchRetrieve
extends AbstractExternalRetrieve {
    private final OpensearchDriver driver;
    private boolean alreadySearched;
    private OpensearchResult result;
    private List<Facet> facets;

    public OpensearchRetrieve(Logger logger, OpensearchStore store, MasterResultIterator mri, ExternalSyncRequestContext requestContext, OpensearchDriver driver) {
        super(logger, (ExternalStore)store, mri, requestContext);
        this.driver = driver;
    }

    public DocumentsResult getDocumentsResult() {
        return this.result;
    }

    public synchronized void close() {
    }

    public synchronized void doSearch() {
        if (this.alreadySearched) {
            this.result = this.result.getResult();
            return;
        }
        ClassLoader pluginClassLoader = this.mri.getPluginClassLoader();
        ClassLoaderUtil.executeWithPluginClassLoader((ClassLoader)pluginClassLoader, () -> {
            this.result = this.driver.query(this.mri);
        });
        this.facets = new ArrayList<Facet>();
        Map<String, Aggregate> openSearchAggregations = this.result.getAggregations();
        if (openSearchAggregations != null) {
            for (Map.Entry<String, Aggregate> aggr : openSearchAggregations.entrySet()) {
                this.processAggregation(aggr.getValue(), aggr.getKey(), 1, 0L, 0L);
            }
        }
        this.alreadySearched = true;
    }

    private void processAggregation(Aggregate aggr, String aggrName, int level, long aggrNameId, long parentId) {
        block25: {
            long levelId;
            block34: {
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            block26: {
                                                block24: {
                                                    if (level == 1) {
                                                        aggrNameId = this.createRequestEntity(aggrName);
                                                    }
                                                    levelId = this.createRequestEntity(level);
                                                    if (aggr._kind() != Aggregate.Kind.Histogram) break block24;
                                                    HistogramAggregate histogram = aggr.histogram();
                                                    for (HistogramBucket bucket : histogram.buckets().array()) {
                                                        String bucketKey = bucket.keyAsString();
                                                        long bucketKeyId = this.createRequestEntity(bucketKey);
                                                        long thisId = this.createRequestBNode();
                                                        FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.FIXED_RANGE, thisId, aggrNameId, parentId, levelId);
                                                        fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, bucketKeyId);
                                                        fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(bucket.docCount()));
                                                        this.faHolder.add(fb);
                                                        this.processChildAggregations((MultiBucketBase)bucket, level + 1, aggrNameId, thisId);
                                                    }
                                                    break block25;
                                                }
                                                if (aggr._kind() != Aggregate.Kind.DateHistogram) break block26;
                                                DateHistogramAggregate histogram = aggr.dateHistogram();
                                                for (DateHistogramBucket bucket : histogram.buckets().array()) {
                                                    String bucketKey = bucket.keyAsString();
                                                    long bucketKeyId = this.createRequestEntity(bucketKey);
                                                    long thisId = this.createRequestBNode();
                                                    FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.FIXED_RANGE, thisId, aggrNameId, parentId, levelId);
                                                    fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, bucketKeyId);
                                                    fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(bucket.docCount()));
                                                    this.faHolder.add(fb);
                                                    this.processChildAggregations((MultiBucketBase)bucket, level + 1, aggrNameId, thisId);
                                                }
                                                break block25;
                                            }
                                            if (aggr._kind() != Aggregate.Kind.Range) break block27;
                                            RangeAggregate range = aggr.range();
                                            for (RangeBucket bucket : range.buckets().array()) {
                                                if (bucket.key() == null) {
                                                    this.logger.warn("Skipping bucket without key {} for aggregation {}", (Object)bucket, (Object)range);
                                                    continue;
                                                }
                                                long bucketKeyId = this.createRequestEntity(bucket.key());
                                                long fromValueId = 0L;
                                                long toValueId = 0L;
                                                if (aggr.isDateRange()) {
                                                    from = bucket.fromAsString();
                                                    if (from != null) {
                                                        fromValueId = this.createRequestEntity(from, XSD.DATETIME);
                                                    }
                                                    if ((to = bucket.toAsString()) != null) {
                                                        toValueId = this.createRequestEntity(to, XSD.DATETIME);
                                                    }
                                                } else {
                                                    from = bucket.from() == null ? bucket.fromAsString() : bucket.from();
                                                    from = from == null ? Double.valueOf(Double.NEGATIVE_INFINITY) : from;
                                                    fromValueId = this.createRequestEntity(from);
                                                    to = bucket.to() == null ? bucket.toAsString() : bucket.to();
                                                    to = to == null ? Double.valueOf(Double.POSITIVE_INFINITY) : to;
                                                    toValueId = this.createRequestEntity(to);
                                                }
                                                long thisId = this.createRequestBNode();
                                                FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.VARIABLE_RANGE, thisId, aggrNameId, parentId, levelId);
                                                fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, bucketKeyId);
                                                fb.setItem(FlexibleBucketItem.FROM, fromValueId);
                                                fb.setItem(FlexibleBucketItem.TO, toValueId);
                                                fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(bucket.docCount()));
                                                this.faHolder.add(fb);
                                                this.processChildAggregations((MultiBucketBase)bucket, level + 1, aggrNameId, thisId);
                                            }
                                            break block25;
                                        }
                                        if (aggr._kind() != Aggregate.Kind.Min) break block28;
                                        FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.STATS, this.createRequestBNode(), aggrNameId, parentId, levelId);
                                        fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, this.createRequestEntity(aggrName));
                                        fb.setItem(FlexibleBucketItem.MIN, this.createRequestEntity(aggr.min().value()));
                                        this.faHolder.add(fb);
                                        break block25;
                                    }
                                    if (aggr._kind() != Aggregate.Kind.Max) break block29;
                                    FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.STATS, this.createRequestBNode(), aggrNameId, parentId, levelId);
                                    fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, this.createRequestEntity(aggrName));
                                    fb.setItem(FlexibleBucketItem.MAX, this.createRequestEntity(aggr.max().value()));
                                    this.faHolder.add(fb);
                                    break block25;
                                }
                                if (aggr._kind() != Aggregate.Kind.Avg) break block30;
                                FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.STATS, this.createRequestBNode(), aggrNameId, parentId, levelId);
                                fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, this.createRequestEntity(aggrName));
                                fb.setItem(FlexibleBucketItem.AVG, this.createRequestEntity(aggr.avg().value()));
                                this.faHolder.add(fb);
                                break block25;
                            }
                            if (aggr._kind() != Aggregate.Kind.Sum) break block31;
                            FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.STATS, this.createRequestBNode(), aggrNameId, parentId, levelId);
                            fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, this.createRequestEntity(aggrName));
                            fb.setItem(FlexibleBucketItem.SUM, this.createRequestEntity(aggr.sum().value()));
                            this.faHolder.add(fb);
                            break block25;
                        }
                        if (aggr._kind() != Aggregate.Kind.ValueCount) break block32;
                        FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.STATS, this.createRequestBNode(), aggrNameId, parentId, levelId);
                        fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, this.createRequestEntity(aggrName));
                        fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(aggr.valueCount().value()));
                        this.faHolder.add(fb);
                        break block25;
                    }
                    if (aggr._kind() != Aggregate.Kind.Stats) break block33;
                    FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.STATS, this.createRequestBNode(), aggrNameId, parentId, levelId);
                    fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, this.createRequestEntity(aggrName));
                    fb.setItem(FlexibleBucketItem.MIN, this.createRequestEntity(aggr.stats().min()));
                    fb.setItem(FlexibleBucketItem.MAX, this.createRequestEntity(aggr.stats().max()));
                    fb.setItem(FlexibleBucketItem.SUM, this.createRequestEntity(aggr.stats().sum()));
                    fb.setItem(FlexibleBucketItem.AVG, this.createRequestEntity(aggr.stats().avg()));
                    fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(aggr.stats().count()));
                    this.faHolder.add(fb);
                    break block25;
                }
                if (aggr._kind() != Aggregate.Kind.ExtendedStats) break block34;
                FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.STATS, this.createRequestBNode(), aggrNameId, parentId, levelId);
                fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, this.createRequestEntity(aggrName));
                fb.setItem(FlexibleBucketItem.MIN, this.createRequestEntity(aggr.extendedStats().min()));
                fb.setItem(FlexibleBucketItem.MAX, this.createRequestEntity(aggr.extendedStats().max()));
                fb.setItem(FlexibleBucketItem.SUM, this.createRequestEntity(aggr.extendedStats().sum()));
                fb.setItem(FlexibleBucketItem.AVG, this.createRequestEntity(aggr.extendedStats().avg()));
                fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(aggr.extendedStats().count()));
                fb.setItem(FlexibleBucketItem.SUM_SQUARES, this.createRequestEntity(aggr.extendedStats().sumOfSquares()));
                fb.setItem(FlexibleBucketItem.STD_DEV, this.createRequestEntity(aggr.extendedStats().stdDeviation()));
                fb.setItem(FlexibleBucketItem.VARIANCE, this.createRequestEntity(aggr.extendedStats().variance()));
                this.faHolder.add(fb);
                break block25;
            }
            if (!this.isMultiBucketAggregate(aggr)) break block25;
            Buckets<TermsBucketBase> buckets = this.getAggregateBuckets(aggr);
            if (buckets == null) {
                this.logger.warn("[{}] Cannot parse multi-bucket aggregate type : {}", (Object)this.externalStore.getName(), (Object)aggr._kind());
                return;
            }
            long facetFieldId = this.createRequestEntity(aggrName);
            if (((TermsAggregateBase)aggr._get()).buckets().isKeyed()) {
                for (Map.Entry bucket : buckets.keyed().entrySet()) {
                    String key = (String)bucket.getKey();
                    long facetCount = ((TermsBucketBase)bucket.getValue()).docCount();
                    this.processMultiTermAggregation(aggrName, key, level, aggrNameId, parentId, levelId, facetCount, facetFieldId, (TermsBucketBase)bucket.getValue());
                }
            } else {
                for (TermsBucketBase bucket : buckets.array()) {
                    Object key = null;
                    long facetCount = bucket.docCount();
                    if (bucket instanceof DoubleTermsBucket) {
                        DoubleTermsBucket doubleTermsBucket = (DoubleTermsBucket)bucket;
                        if (this.extractTypeFromName(aggrName) != null) {
                            key = doubleTermsBucket.keyAsString();
                        }
                        if (key == null) {
                            key = doubleTermsBucket.key();
                        }
                    } else if (bucket instanceof StringTermsBucket) {
                        key = ((StringTermsBucket)bucket).key();
                    } else {
                        LongTermsBucket longTermsBucket = (LongTermsBucket)bucket;
                        if (this.extractTypeFromName(aggrName) != null) {
                            key = longTermsBucket.keyAsString();
                        }
                        if (key == null) {
                            try {
                                key = longTermsBucket.key().signed();
                            }
                            catch (Exception e) {
                                key = longTermsBucket.key();
                            }
                        }
                    }
                    this.processMultiTermAggregation(aggrName, key, level, aggrNameId, parentId, levelId, facetCount, facetFieldId, bucket);
                }
            }
        }
    }

    private void processMultiTermAggregation(String aggrName, Object key, int level, long aggrNameId, long parentId, long levelId, long facetCount, long facetFieldId, TermsBucketBase bucket) {
        String hintedType = this.extractTypeFromName(aggrName);
        long facetValueId = hintedType != null ? this.createRequestEntity(key.toString(), hintedType) : (level == 1 && this.externalStore.isFieldURI(aggrName) && this.mri.getSearchOptions().facets.contains(aggrName) ? this.createRequestEntity((Value)this.valueFactory.createIRI(key.toString())) : this.createRequestEntity(key));
        long thisId = this.createRequestBNode();
        FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.FACET, thisId, aggrNameId, parentId, levelId);
        fb.setItem(FlexibleBucketItem.KEY_AS_STRING, this.createRequestEntity(key));
        fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, facetValueId);
        fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(facetCount));
        fb.setItem(FlexibleBucketItem.LEVEL_NAME, facetFieldId);
        this.faHolder.add(fb);
        this.processChildAggregations((MultiBucketBase)bucket, level + 1, aggrNameId, thisId);
        if (level == 1) {
            this.facets.add(new Facet(facetFieldId, facetValueId, facetCount));
        }
    }

    private void processChildAggregations(MultiBucketBase bucket, int level, long aggrNameId, long parentId) {
        Map aggregationChildren = bucket.aggregations();
        if (aggregationChildren != null) {
            for (Map.Entry child : aggregationChildren.entrySet()) {
                this.processAggregation((Aggregate)child.getValue(), (String)child.getKey(), level + 1, aggrNameId, parentId);
            }
        }
    }

    private String extractTypeFromName(String aggrName) {
        int hintIndex = aggrName.indexOf(36);
        if (hintIndex >= 0) {
            return aggrName.substring(hintIndex + 1);
        }
        return null;
    }

    private long createRequestEntity(String value, String type) {
        switch (type.toLowerCase()) {
            case "iri": 
            case "uri": {
                return this.mri.getEntities().put((Value)this.valueFactory.createIRI(value), Entities.Scope.REQUEST);
            }
            case "int": {
                return this.mri.getEntities().put((Value)this.valueFactory.createLiteral(value, XSD.INT), Entities.Scope.REQUEST);
            }
            case "long": {
                return this.mri.getEntities().put((Value)this.valueFactory.createLiteral(value, XSD.LONG), Entities.Scope.REQUEST);
            }
            case "float": {
                return this.mri.getEntities().put((Value)this.valueFactory.createLiteral(value, XSD.FLOAT), Entities.Scope.REQUEST);
            }
            case "double": {
                return this.mri.getEntities().put((Value)this.valueFactory.createLiteral(value, XSD.DOUBLE), Entities.Scope.REQUEST);
            }
            case "date": {
                return this.mri.getEntities().put((Value)this.temporalLiteral(value, XSD.DATE), Entities.Scope.REQUEST);
            }
            case "datetime": {
                return this.mri.getEntities().put((Value)this.temporalLiteral(value, XSD.DATETIME), Entities.Scope.REQUEST);
            }
            case "time": {
                return this.mri.getEntities().put((Value)this.temporalLiteral(value, XSD.TIME), Entities.Scope.REQUEST);
            }
            case "gyear": {
                return this.mri.getEntities().put((Value)this.temporalLiteral(value, XSD.GYEAR), Entities.Scope.REQUEST);
            }
            case "gyearmonth": {
                return this.mri.getEntities().put((Value)this.temporalLiteral(value, XSD.GYEARMONTH), Entities.Scope.REQUEST);
            }
        }
        return this.mri.getEntities().put((Value)this.valueFactory.createLiteral(value), Entities.Scope.REQUEST);
    }

    private Literal temporalLiteral(String value, IRI datatype) {
        try {
            return ValuesUtil.INSTANCE.isoToXsd(value, datatype, this.valueFactory);
        }
        catch (DateTimeParseException e) {
            this.logger.warn("[{}] Cannot parse temporal value: {}", (Object)this.externalStore.getName(), (Object)value);
            return this.valueFactory.createLiteral(value);
        }
    }

    private Buckets<TermsBucketBase> getAggregateBuckets(Aggregate aggregate) {
        try {
            return ((TermsAggregateBase)aggregate._get()).buckets();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private boolean isMultiBucketAggregate(Aggregate aggr) {
        return aggr._get() instanceof TermsAggregateBase;
    }

    public List<Facet> getFacets() {
        return this.facets;
    }
}

