/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity.iterators;

import com.ontotext.trree.plugin.similarity.SimilarityIndex;
import com.ontotext.trree.plugin.similarity.iterators.AbstractResultIterator;
import com.ontotext.trree.plugin.similarity.iterators.MasterResultIterator;
import com.ontotext.trree.plugin.similarity.iterators.NeedsMasterResult;
import com.ontotext.trree.plugin.similarity.iterators.SimilarityEntityResult;
import com.ontotext.trree.sdk.Entities;
import java.io.IOException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.VectorStoreReader;
import pitt.search.semanticvectors.VectorStoreUtils;

public class EntityResultIterator
extends AbstractResultIterator
implements NeedsMasterResult {
    private Logger LOGGER = LoggerFactory.getLogger(EntityResultIterator.class);
    private MasterResultIterator mri;
    private SimilarityEntityResult similarityResult;
    private SimilarityIndex.SearchType searchType;

    @Override
    public void setMasterResultIterator(MasterResultIterator mri) {
        this.mri = mri;
        mri.setEntitySubjectFilter(this.object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nextInternal() {
        block14: {
            Object searchString;
            SimilarityIndex.SearchType actualST;
            block16: {
                block17: {
                    block15: {
                        if (this.similarityResult != null) break block14;
                        if (this.mri.getSimilarityIndex() == null) {
                            return false;
                        }
                        actualST = this.searchType;
                        if (this.searchType.isPSI() && this.mri.getPsiQueryPredicate() != null) {
                            actualST = SimilarityIndex.SearchType.PSI_PREDICATE;
                        }
                        if (!actualST.fromTerm()) break block15;
                        searchString = this.mri.getQueryString();
                        break block16;
                    }
                    if (!this.searchType.equals((Object)SimilarityIndex.SearchType.PSI_ANALOGICAL)) break block17;
                    Long querySubject = this.mri.getQuerySubject();
                    Long queryObject = this.mri.getQueryObject();
                    Long searchSubject = this.mri.getSearchSubject();
                    if (querySubject == null || queryObject == null || searchSubject == null) {
                        this.LOGGER.error(String.format("Null values not allowed on analogical search querySubject: %s queryObject: %s searchSubject: %s", querySubject, queryObject, searchSubject));
                    }
                    try {
                        CloseableVectorStore elementalVectorStore = VectorStoreReader.openVectorStore((String)this.mri.getSimilarityIndex().getConfig().elementalvectorfile(), (FlagConfig)this.mri.getSimilarityIndex().getConfig());
                        if (!elementalVectorStore.containsVector((Object)queryObject)) {
                            this.LOGGER.info("No vector for object " + this.getEntities().get(queryObject.longValue()).stringValue());
                            elementalVectorStore.close();
                            return false;
                        }
                        elementalVectorStore.close();
                        CloseableVectorStore semanticVectorStore = VectorStoreReader.openVectorStore((String)this.mri.getSimilarityIndex().getConfig().semanticvectorfile(), (FlagConfig)this.mri.getSimilarityIndex().getConfig());
                        if (!semanticVectorStore.containsVector((Object)querySubject)) {
                            this.LOGGER.info("No vector for subject " + this.getEntities().get(querySubject.longValue()).stringValue());
                            semanticVectorStore.close();
                            return false;
                        }
                        if (!semanticVectorStore.containsVector((Object)searchSubject)) {
                            this.LOGGER.info("No vector for subject " + this.getEntities().get(querySubject.longValue()).stringValue());
                            semanticVectorStore.close();
                            return false;
                        }
                        semanticVectorStore.close();
                    }
                    catch (IOException e) {
                        this.LOGGER.error("Could not open predication vector store.");
                    }
                    searchString = String.format("E(%s)*S(%s)*S(%s)", queryObject, querySubject, searchSubject);
                    break block16;
                }
                Long searchPred = this.mri.getPsiQueryPredicate();
                if (searchPred != null) {
                    CloseableVectorStore closeableVectorStore;
                    block13: {
                        boolean searchSubject;
                        closeableVectorStore = null;
                        try {
                            closeableVectorStore = VectorStoreReader.openVectorStore((String)this.mri.getSimilarityIndex().getConfig().elementalpredicatevectorfile(), (FlagConfig)this.mri.getSimilarityIndex().getConfig());
                            if (closeableVectorStore.containsVector((Object)searchPred.toString())) break block13;
                            this.LOGGER.info("No vector for predicate " + this.getEntities().get(searchPred.longValue()).stringValue());
                            searchSubject = false;
                        }
                        catch (IOException e) {
                            try {
                                this.LOGGER.error("Could not open predication vector store.");
                            }
                            catch (Throwable throwable) {
                                VectorStoreUtils.closeVectorStores((CloseableVectorStore[])new CloseableVectorStore[]{closeableVectorStore});
                                throw throwable;
                            }
                            VectorStoreUtils.closeVectorStores((CloseableVectorStore[])new CloseableVectorStore[]{closeableVectorStore});
                        }
                        VectorStoreUtils.closeVectorStores((CloseableVectorStore[])new CloseableVectorStore[]{closeableVectorStore});
                        return searchSubject;
                    }
                    VectorStoreUtils.closeVectorStores((CloseableVectorStore[])new CloseableVectorStore[]{closeableVectorStore});
                }
                searchString = this.mri.getQueryEntity() + (String)(searchPred != null ? " " + searchPred : "");
            }
            this.similarityResult = new SimilarityEntityResult(this.mri.getSimilarityIndex().search(actualST, (String)searchString, this.mri.getSearchOptions()), actualST);
            this.similarityResult.setEntities(this.getEntities());
        }
        return this.similarityResult.next();
    }

    public boolean next() {
        if (this.closed) {
            return false;
        }
        if (this.nextInternal()) {
            BNode currentObject = SimpleValueFactory.getInstance().createBNode();
            this.object = this.entities.put((Value)currentObject, Entities.Scope.REQUEST);
            return true;
        }
        this.unregisterIterator();
        return false;
    }

    public final long getCurrentValue() {
        return this.similarityResult.getCurrentValue();
    }

    public final double getCurrentScore() {
        return this.similarityResult.getCurrentScore();
    }

    public void setSearchType(SimilarityIndex.SearchType searchType) {
        this.searchType = searchType;
    }

    public void unregisterIterator() {
        this.mri.unregisterIterator(this);
    }

    public void unregisterIterator(AbstractResultIterator iterator) {
        this.mri.unregisterIterator(iterator);
    }

    public long createMissingId(String id) {
        return this.entities.put((Value)SimpleValueFactory.getInstance().createBNode(id), Entities.Scope.REQUEST);
    }
}

