/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.trree.plugin.similarity.SimilarityIndex;
import com.ontotext.trree.plugin.similarity.psi.SimilarityPredicationIndex;
import com.ontotext.trree.plugin.similarity.text.SimilarityTextIndex;
import com.ontotext.trree.sdk.PluginException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class SimilarityIndexes {
    public static void serialize(SimilarityIndex similarityIndex) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        try (FileOutputStream fos = new FileOutputStream(new File(similarityIndex.getHomeDir(), similarityIndex.getName() + ".json"));){
            fos.write(mapper.writeValueAsString((Object)similarityIndex).getBytes());
        }
    }

    public static SimilarityIndex deserialize(File serialized) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Class clazz = null;
        String type = mapper.readTree(serialized).get("type").textValue();
        if ("text".equals(type) || "textLiteral".equals(type)) {
            clazz = SimilarityTextIndex.class;
        }
        if ("predication".equals(type)) {
            clazz = SimilarityPredicationIndex.class;
        }
        if (clazz == null) {
            throw new PluginException("Unrecognized type " + type);
        }
        SimilarityIndex similarityIndex = (SimilarityIndex)new ObjectMapper().readValue(serialized, clazz);
        similarityIndex.setConfig(similarityIndex.initialConfigParams);
        return similarityIndex;
    }
}

