/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity;

import com.ontotext.trree.plugin.similarity.IndexWriter;
import com.ontotext.trree.plugin.similarity.handlers.CustomSlf4jHandler;
import com.ontotext.trree.sdk.PluginException;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.SearchResult;
import pitt.search.semanticvectors.lsh.LSHStoreFactory;
import pitt.search.semanticvectors.utils.VerbatimLogger;

public abstract class SimilarityIndex<T extends IndexWriter> {
    private static final Logger LOGGER;
    public static final String INDEX_TEMP_DIR_PREFIX = "tmp_";
    String name;
    protected String initialConfigParams;
    protected int docCount;
    protected long fingerprint;
    protected long transactionFingerprint;
    private File homeDir;
    private Path tmpHomeDir;
    private Status status;
    protected FlagConfig config;
    protected FlagConfig rebuildFlagConfig;
    private Optional<Consumer<SimilarityIndex>> deleteListener;
    private boolean recreated = false;
    protected T writer;
    protected String type;
    protected AtomicBoolean interruptIndexCreation = new AtomicBoolean(false);
    protected final AtomicInteger activeSearchesCounter = new AtomicInteger(0);
    protected AtomicLong specialStamp = new AtomicLong(0L);
    protected final StampedLock activeSearchLock = new StampedLock();

    public SimilarityIndex() {
    }

    public SimilarityIndex(String name, String initialConfigParams, String type) {
        this.name = name;
        this.initialConfigParams = initialConfigParams;
        this.status = Status.BUILDING;
        this.fingerprint = 0L;
        this.deleteListener = Optional.empty();
        this.type = type;
    }

    public void initialize(File parentDir) throws IOException {
        this.initialize(parentDir, false);
    }

    public void initialize(File parentDir, boolean overwrite) throws IOException {
        File tempDir;
        this.homeDir = new File(parentDir, this.name).getCanonicalFile();
        if (overwrite && this.homeDir.exists()) {
            LOGGER.info("{} index exists. Will be deleted and recreated", (Object)this.name);
            this.recreated = true;
            LSHStoreFactory.INSTANCE.clearStoresForIndex(this.homeDir);
            FileUtils.deleteDirectory((File)this.homeDir);
        }
        if ((tempDir = new File(parentDir, INDEX_TEMP_DIR_PREFIX + this.name)).exists()) {
            FileUtils.deleteDirectory((File)tempDir);
        }
        Files.createDirectories(this.homeDir.toPath(), new FileAttribute[0]);
        this.setConfig(this.initialConfigParams);
    }

    public void prepareForBuild() throws IOException {
        File indexDir;
        if (this.status == Status.REBUILDING) {
            this.tmpHomeDir = Paths.get(this.homeDir.getAbsolutePath().replaceFirst(this.name, INDEX_TEMP_DIR_PREFIX + this.name), new String[0]);
            Files.createDirectories(this.tmpHomeDir, new FileAttribute[0]);
            indexDir = Paths.get(this.tmpHomeDir.toUri()).resolve(this.name).toFile();
            this.setConfig(this.initialConfigParams);
        } else {
            indexDir = new File(this.homeDir, this.name);
        }
        if (indexDir.exists()) {
            LOGGER.info("Index directory exists and will be deleted");
            FileUtils.deleteDirectory((File)indexDir);
            LOGGER.info("Index directory deleted successfully");
        }
        this.initializeWriter(indexDir);
        this.docCount = 0;
        this.transactionFingerprint = 0L;
    }

    protected abstract void initializeWriter(File var1) throws IOException;

    public void delete() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.homeDir == null) {
            return;
        }
        LSHStoreFactory.INSTANCE.clearStoresForIndex(this.homeDir);
        FileUtils.deleteDirectory((File)this.homeDir);
        this.writer = null;
        this.transactionFingerprint = 0L;
        this.fingerprint = 0L;
        this.deleteListener.ifPresent(listener -> listener.accept(this));
        LOGGER.info("Index {} deleted", (Object)this.name);
    }

    public boolean buildIndex() throws IOException {
        if (this.writer != null) {
            LOGGER.info("Totally {} documents indexed in lucene", (Object)this.docCount);
            this.writer.close();
        }
        if (this.docCount == 0) {
            if (!this.recreated) {
                this.delete();
            } else {
                this.status = Status.FAILED;
            }
            return false;
        }
        long start = System.currentTimeMillis();
        LOGGER.info("Start building semantic index {}", (Object)this.name);
        if (this.getStatus() != Status.REBUILDING) {
            this.setStatus(Status.BUILDING);
        }
        try {
            if (this.buildVectorsIndex(this.getCurrentFlagConfig())) {
                this.status = Status.BUILT;
                this.fingerprint ^= this.transactionFingerprint;
                LOGGER.info("Finished building semantic index {} in {} ms", (Object)this.name, (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            boolean isRebuilding;
            boolean bl = isRebuilding = this.getStatus() == Status.REBUILDING;
            if (this.interruptIndexCreation.compareAndSet(true, false)) {
                this.setStatus(isRebuilding ? this.getStatus() : Status.INTERRUPTED);
                LOGGER.info("{} index {} interrupted", (Object)(isRebuilding ? "Rebuilding" : "Building"), (Object)this.name);
            } else {
                this.setStatus(isRebuilding ? this.getStatus() : Status.FAILED);
                LOGGER.error("{} index {} failed", new Object[]{isRebuilding ? "Rebuilding" : "Building", this.name, e});
            }
            throw e;
        }
        finally {
            this.replaceExistingIndexDir();
        }
        return true;
    }

    protected abstract boolean buildVectorsIndex(FlagConfig var1) throws IOException;

    public String getName() {
        return this.name;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getFingerprint() {
        return this.fingerprint;
    }

    public String getInitialConfigParams() {
        return this.initialConfigParams;
    }

    public void setDeleteListener(Consumer<SimilarityIndex> deleteListener) {
        this.deleteListener = Optional.of(deleteListener);
    }

    public String getType() {
        return this.type;
    }

    protected abstract void setConfig(String var1);

    public boolean outdate() {
        if (this.status == Status.BUILT) {
            this.status = Status.OUTDATED;
            return true;
        }
        return false;
    }

    protected void relationalizeConfigFilePaths() {
        for (Field field : FlagConfig.class.getDeclaredFields()) {
            if (!field.getName().endsWith("file")) continue;
            try {
                field.setAccessible(true);
                String originalValue = field.get(this.getCurrentFlagConfig()).toString();
                if (originalValue.isEmpty()) continue;
                String relationalized = this.relationalizeFile(originalValue);
                field.set(this.getCurrentFlagConfig(), relationalized);
            }
            catch (IOException | IllegalAccessException e) {
                throw new PluginException("Could not create plugin configuration", (Throwable)e);
            }
        }
    }

    protected String relationalizeFile(String file) throws IOException {
        String rationalizedDir = this.status == Status.REBUILDING ? this.getHomeDir().getCanonicalPath().replaceFirst(this.name, INDEX_TEMP_DIR_PREFIX + this.name) : this.getHomeDir().getCanonicalPath();
        return Paths.get(rationalizedDir, file).toString();
    }

    @Transient
    public FlagConfig getConfig() {
        return this.config;
    }

    public abstract List<SearchResult> search(SearchType var1, String var2, String var3);

    public boolean prepared() {
        return this.writer != null;
    }

    private static void redirectVerbatimLoggerLogger() {
        VerbatimLogger.log((Level)Level.FINE, (String)"");
        LogManager manager = LogManager.getLogManager();
        java.util.logging.Logger logger = manager.getLogger(VerbatimLogger.class.getSimpleName());
        if (logger != null) {
            Arrays.asList(logger.getHandlers()).forEach(logger::removeHandler);
            logger.addHandler(new CustomSlf4jHandler());
        }
    }

    protected void clearIndexData() {
        if (this.tmpHomeDir != null) {
            FileUtils.deleteQuietly((File)this.tmpHomeDir.toFile());
            this.tmpHomeDir = null;
            return;
        }
        LOGGER.info("Removing data for index {} from {}", (Object)this.name, (Object)this.homeDir.getAbsolutePath());
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            LSHStoreFactory.INSTANCE.clearStoresForIndex(this.homeDir);
            this.writer = null;
            this.deleteIndexDir(this.homeDir);
        }
        catch (IOException e) {
            LOGGER.warn("Could not delete data for index {} from {}", new Object[]{this.name, this.homeDir.getAbsolutePath(), e});
        }
    }

    private void deleteIndexDir(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Provided path is not a directory: " + directory);
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".json")) continue;
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    private void replaceExistingIndexDir() {
        if (this.tmpHomeDir != null) {
            long stamp = 0L;
            try {
                stamp = this.activeSearchLock.writeLock();
                if (this.writer != null) {
                    this.writer.close();
                }
                if (this.homeDir == null) {
                    return;
                }
                this.writer = null;
                LSHStoreFactory.INSTANCE.clearStoresForIndex(this.tmpHomeDir.toFile());
                Path indexDirPath = this.homeDir.toPath();
                FileUtils.deleteDirectory((File)this.homeDir);
                Files.move(this.tmpHomeDir, indexDirPath, StandardCopyOption.ATOMIC_MOVE);
                FileUtils.deleteDirectory((File)this.tmpHomeDir.toFile());
            }
            catch (IOException e) {
                throw new PluginException(String.format("Could not move index %s temporary directory", this.name), (Throwable)e);
            }
            finally {
                this.tmpHomeDir = null;
                this.rebuildFlagConfig = null;
                this.activeSearchLock.unlockWrite(stamp);
            }
        }
    }

    protected FlagConfig getCurrentFlagConfig() {
        return this.status == Status.REBUILDING ? this.rebuildFlagConfig : this.config;
    }

    protected boolean isIndexSearchable() {
        switch (this.status) {
            case REBUILDING: 
            case BUILT: 
            case OUTDATED: {
                return true;
            }
        }
        return false;
    }

    static {
        SimilarityIndex.redirectVerbatimLoggerLogger();
        LOGGER = LoggerFactory.getLogger(SimilarityIndex.class);
    }

    public static enum Status {
        BUILDING,
        REBUILDING,
        BUILT,
        OUTDATED,
        FAILED,
        OBSOLETE,
        INTERRUPTED;

    }

    public static enum SearchType {
        TERM_TO_TERM(17),
        TERM_TO_DOC(1),
        DOC_TO_TERM(16),
        DOC_TO_DOC(0),
        PSI(256),
        PSI_PREDICATE(256),
        PSI_ANALOGICAL(256);

        int mask;

        private SearchType(int mask) {
            this.mask = mask;
        }

        public boolean fromTerm() {
            return (this.mask & 1) != 0;
        }

        public boolean toTerm() {
            return (this.mask & 0x10) != 0;
        }

        public boolean isPSI() {
            return (this.mask & 0x100) != 0;
        }
    }
}

