/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.util;

import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.SailConnectionImpl;
import com.ontotext.trree.SchemaRepositoryAccess;
import com.ontotext.trree.sdk.Repository;
import com.ontotext.trree.sdk.impl.DummyPluginRepository;
import com.ontotext.trree.sdk.impl.SailConnectionPluginRepository;
import com.ontotext.trree.statistics.StatisticsSettings;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.rdf4j.sail.SailConnection;
import org.jetbrains.annotations.Nullable;

public class StatisticsUtil {
    private StatisticsUtil() {
    }

    public static Consumer<String> vectorQueryRecorderFor(Repository repository) {
        if (!StatisticsSettings.getInstance().isStatisticsEnabled()) {
            return null;
        }
        if (repository instanceof DummyPluginRepository) {
            DummyPluginRepository dummyPluginRepository = (DummyPluginRepository)repository;
            return dummyPluginRepository.getVectorQueryRecorder();
        }
        OwlimSchemaRepository owlimSchemaRepository = StatisticsUtil.getOwlimSchemaRepository(repository);
        if (owlimSchemaRepository == null) {
            return null;
        }
        return pluginName -> owlimSchemaRepository.getStatistics().recordVectorQuery(pluginName);
    }

    public static BiConsumer<String, Boolean> pluginCreationRecorderFor(Repository repository) {
        if (!StatisticsSettings.getInstance().isStatisticsEnabled()) {
            return null;
        }
        if (repository instanceof DummyPluginRepository) {
            DummyPluginRepository dummyPluginRepository = (DummyPluginRepository)repository;
            return dummyPluginRepository.getPluginCreationRecorder();
        }
        OwlimSchemaRepository owlimSchemaRepository = StatisticsUtil.getOwlimSchemaRepository(repository);
        if (owlimSchemaRepository == null) {
            return null;
        }
        return (pluginName, success) -> owlimSchemaRepository.getStatistics().recordPluginCreation(pluginName, success.booleanValue());
    }

    @Nullable
    private static OwlimSchemaRepository getOwlimSchemaRepository(Repository repository) {
        if (!(repository instanceof SailConnectionPluginRepository)) {
            return null;
        }
        SailConnectionPluginRepository pluginRepository = (SailConnectionPluginRepository)repository;
        SailConnection sailConn = pluginRepository.getSailConnection();
        if (!(sailConn instanceof SailConnectionImpl)) {
            return null;
        }
        SchemaRepositoryAccess owlim = ((SailConnectionImpl)sailConn).getOwlim();
        if (!(owlim instanceof OwlimSchemaRepository)) {
            return null;
        }
        OwlimSchemaRepository owlimSchemaRepository = (OwlimSchemaRepository)owlim;
        return owlimSchemaRepository;
    }
}

