/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl;

import com.ontotext.trree.plugin.externalsync.filter.Expression;
import com.ontotext.trree.plugin.externalsync.filter.TrueExpression;
import com.ontotext.trree.plugin.externalsync.impl.FieldName;
import com.ontotext.trree.plugin.externalsync.impl.FieldNameTransform;
import com.ontotext.trree.plugin.externalsync.util.PropertyUtil;
import com.ontotext.trree.sdk.Entities;
import gnu.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class Property {
    public static final String SELF_PSEUDO_URI = "$self";
    public static final String LITERAL_PSEUDO_URI = "$literal";
    public static final String ANY_TYPE_PSEUDO_URI = "$any";
    public static final String UNTYPED_PSEUDO_URI = "$untyped";
    public static final String REFERENCE_PREFIX = "@";
    public static final String LANG_PSEUDO_URI = "lang()";
    public static final String GRAPH_PSEUDO_URI = "graph()";
    public static final String LOCAL_NAME_PSEUDO_IRI = "localname()";
    public static final String MULTIFIELD_SUFFIX = "$";
    public static final String MULTIFIELD_SUFFIX_LEGACY = "/";
    public static final String TEXT_TO_VECTOR_TYPE = "vector";
    public static final String SEMANTIC_PROPERTY_KIND = "semantic";
    public static final boolean INDEXED_DEFAULT = true;
    public static final boolean STORED_DEFAULT = true;
    public static final boolean ANALYZED_DEFAULT = true;
    public static final boolean MULTIVALUED_DEFAULT = true;
    public static final boolean IGNORE_INVALID_DEFAULT = false;
    public static final boolean FACET_DEFAULT = true;
    public static final boolean FIELDDATA_DEFAULT = false;
    public static final boolean ARRAY_DEFAULT = false;
    public static final long ANY_LITERAL_ID = Integer.MIN_VALUE;
    public static final long ANY_TYPE_ID = -2147483647L;
    public static final long UNTYPED_ID = -2147483646L;
    private final List<String> propertyUris;
    private final String propertyParam;
    long[] owlimIds;
    boolean[] inverseIri;
    private FieldName fieldName;
    private List<String> allFieldNames;
    private FieldNameTransform fieldNameTransform = FieldNameTransform.NONE_TRANSFORM;
    private long defaultValue = 0L;
    private boolean isSelf;
    private String referenceTo;
    private boolean isLang;
    private boolean isGraph;
    private boolean isLocalName;
    private final boolean[] hasFilterAtPosition;
    private final TLongHashSet[] nextHopIdsAtPositionSets;
    private Expression documentFilterExpr = TrueExpression.INSTANCE;
    private String documentFilterString;
    private Expression valueFilterExpr = TrueExpression.INSTANCE;
    private String valueFilterString;
    private final Set<Property> filterDependencies = new HashSet<Property>();
    long[][] nextHopIdsAtPosition;
    private boolean stored = true;
    private boolean indexed = true;
    private boolean analyzed = true;
    private boolean multivalued = true;
    private boolean ignoreInvalidValues = false;
    private boolean facet = true;
    private boolean fielddata;
    private boolean array;
    private String analyzer;
    private long objectStartFromParent;
    private List<Property> object = Collections.emptyList();
    private IRI xsdType;
    private String nativeType;
    private Map<String, ?> nativeSettings = Collections.emptyMap();
    private Property parentProperty;
    private List<Property> referredFromProperties = Collections.emptyList();

    private Property(List<String> properties) {
        String uri;
        if (properties.size() == 1 && (uri = properties.get(0)).startsWith(REFERENCE_PREFIX)) {
            this.referenceTo = uri.substring(1);
            properties = Collections.emptyList();
        }
        this.inverseIri = new boolean[properties.size()];
        if (properties.isEmpty()) {
            this.propertyUris = Collections.emptyList();
            this.propertyParam = null;
        } else {
            ArrayList<String> lissy = new ArrayList<String>(properties);
            String lastInChain = (String)lissy.get(lissy.size() - 1);
            int lastIndexOfCaret = lastInChain.indexOf(94);
            if (lastIndexOfCaret > 0) {
                lissy.set(lissy.size() - 1, lastInChain.substring(0, lastIndexOfCaret));
                this.propertyParam = lastInChain.substring(lastIndexOfCaret + 1);
            } else {
                this.propertyParam = null;
            }
            this.propertyUris = Collections.unmodifiableList(lissy);
        }
        this.hasFilterAtPosition = new boolean[this.propertyUris.size()];
        this.nextHopIdsAtPositionSets = new TLongHashSet[this.propertyUris.size()];
        this.nextHopIdsAtPosition = new long[this.propertyUris.size()][];
    }

    public List<String> getPropertyChain() {
        return this.propertyUris;
    }

    public boolean isPropertyChain() {
        return this.owlimIds.length > 1;
    }

    @Nullable
    public String getPropertyParam() {
        return this.propertyParam;
    }

    public FieldName getFieldName() {
        return this.fieldName;
    }

    public String getFieldNameWithoutSuffix() {
        return this.fieldName.fieldNameWithoutSuffix;
    }

    public FieldNameTransform getFieldNameTransform() {
        return this.fieldNameTransform;
    }

    public List<String> getAllFieldNames() {
        return this.allFieldNames;
    }

    public String getFieldNameSuffix() {
        return this.fieldName.fieldNameSuffix;
    }

    public String getFieldNameWithSuffix() {
        return this.fieldName.fieldNameWithSuffix;
    }

    private static Property createProperty(List<String> uris, Entities entities) {
        Property p = new Property(uris);
        p.owlimIds = new long[p.propertyUris.size()];
        for (int i = 0; i < p.owlimIds.length; ++i) {
            String uri = p.propertyUris.get(i);
            if (SELF_PSEUDO_URI.equals(uri)) {
                p.owlimIds[i] = 0L;
                p.isSelf = true;
                continue;
            }
            if (LITERAL_PSEUDO_URI.equals(uri)) {
                p.owlimIds[i] = Integer.MIN_VALUE;
                continue;
            }
            if (LANG_PSEUDO_URI.equalsIgnoreCase(uri)) {
                p.owlimIds[i] = 0L;
                p.isLang = true;
                continue;
            }
            if (GRAPH_PSEUDO_URI.equalsIgnoreCase(uri)) {
                p.owlimIds[i] = 0L;
                p.isGraph = true;
                continue;
            }
            if (LOCAL_NAME_PSEUDO_IRI.equalsIgnoreCase(uri)) {
                p.owlimIds[i] = 0L;
                p.isLocalName = true;
                continue;
            }
            if (uri.charAt(0) == '^') {
                p.inverseIri[i] = true;
                uri = uri.substring(1);
            }
            p.owlimIds[i] = entities.put((Value)SimpleValueFactory.getInstance().createIRI(uri), Entities.Scope.DEFAULT);
        }
        return p;
    }

    public static Property createProperty(String fieldName, FieldNameTransform fieldNameTransform, List<String> uris, Entities entities, @Nullable Property parentProperty, String multifieldSuffix) {
        Property p = Property.createProperty(uris, entities);
        p.parentProperty = parentProperty;
        String prefix = parentProperty != null ? parentProperty.getCanonicalPrefixForChildren() : "";
        int indexOfSuffix = fieldName.indexOf(multifieldSuffix);
        p.fieldName = indexOfSuffix > 0 ? new FieldName(prefix, fieldName, fieldName.substring(0, indexOfSuffix)) : new FieldName(prefix, fieldName, fieldName);
        p.fieldNameTransform = fieldNameTransform;
        p.allFieldNames = Collections.singletonList(fieldName);
        return p;
    }

    public static Property createThisProperty(Entities entities) {
        Property p = Property.createProperty(Collections.singletonList(SELF_PSEUDO_URI), entities);
        p.fieldName = FieldName.THIS_FIELDNAME;
        p.allFieldNames = Collections.singletonList(p.fieldName.fieldNameWithSuffix);
        return p;
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    public IRI getXsdType() {
        return this.xsdType;
    }

    public void setXsdType(IRI xsdType) {
        this.xsdType = xsdType;
    }

    public String getNativeType() {
        return this.nativeType;
    }

    public void setNativeType(String nativeType) {
        this.nativeType = nativeType;
    }

    public Map<String, ?> getNativeSettings() {
        return this.nativeSettings;
    }

    public void setNativeSettings(Map<String, ?> nativeSettings) {
        this.nativeSettings = nativeSettings;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public boolean isLiteralAt(int pos) {
        return this.owlimIds[pos] == Integer.MIN_VALUE;
    }

    public boolean isReferenceTo() {
        return this.referenceTo != null;
    }

    public String getReferenceTo() {
        return this.referenceTo;
    }

    public boolean isLang() {
        return this.isLang;
    }

    public boolean isGraph() {
        return this.isGraph;
    }

    public boolean isLocalName() {
        return this.isLocalName;
    }

    public void setHasFilterAtPosition(boolean hasFilter, int pos) {
        this.hasFilterAtPosition[pos] = hasFilter;
    }

    public boolean hasFilterAtPosition(int pos) {
        return this.hasFilterAtPosition[pos];
    }

    public void addNextHopIdAtPosition(long id, int pos) {
        if (this.nextHopIdsAtPositionSets[pos] == null) {
            this.nextHopIdsAtPositionSets[pos] = new TLongHashSet(2);
        }
        this.nextHopIdsAtPositionSets[pos].add(id);
    }

    public boolean isStored() {
        return this.stored;
    }

    public void setStored(boolean stored) {
        this.stored = stored;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public void setAnalyzed(boolean analyzed) {
        this.analyzed = analyzed;
    }

    public boolean isMultivalued() {
        return this.multivalued;
    }

    public void setMultivalued(boolean multivalued) {
        this.multivalued = multivalued;
    }

    public boolean isIgnoreInvalidValues() {
        return this.ignoreInvalidValues;
    }

    public void setIgnoreInvalidValues(boolean ignoreInvalidValues) {
        this.ignoreInvalidValues = ignoreInvalidValues;
    }

    public boolean isFacet() {
        return this.facet && !this.isSelf;
    }

    public void setFacet(boolean facet) {
        this.facet = facet;
    }

    public boolean isFielddata() {
        return this.fielddata;
    }

    public void setFielddata(boolean fielddata) {
        this.fielddata = fielddata;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public List<Property> getReferredFromProperties() {
        return this.referredFromProperties;
    }

    public void addReferredFromProperty(Property property) {
        if (this.referredFromProperties.isEmpty()) {
            this.referredFromProperties = new ArrayList<Property>(2);
        }
        this.referredFromProperties.add(property);
        this.allFieldNames = new ArrayList<String>(1 + this.referredFromProperties.size());
        this.allFieldNames.add(this.fieldName.fieldNameWithoutSuffix);
        for (Property referring : this.referredFromProperties) {
            this.allFieldNames.add(referring.getFieldNameWithoutSuffix());
        }
    }

    public List<Property> getObject() {
        return this.object;
    }

    public void addObjectProperty(Property property) {
        if (this.object.isEmpty()) {
            this.object = new ArrayList<Property>(4);
        }
        this.object.add(property);
    }

    public long getObjectStartFromParent() {
        return this.objectStartFromParent;
    }

    public void setObjectStartFromParent(long objectStartFromParent) {
        this.objectStartFromParent = objectStartFromParent;
    }

    public void setValueFilterString(String valueFilterString) {
        this.valueFilterString = valueFilterString;
    }

    public String getValueFilterString() {
        return this.valueFilterString;
    }

    public void setValueFilterExpr(Expression valueFilterExpr) {
        this.valueFilterExpr = valueFilterExpr;
    }

    public Expression getValueFilterExpr() {
        return this.valueFilterExpr;
    }

    public void setDocumentFilterString(String documentFilterString) {
        this.documentFilterString = documentFilterString;
    }

    public String getDocumentFilterString() {
        return this.documentFilterString;
    }

    public void setDocumentFilterExpr(Expression documentFilterExpr) {
        this.documentFilterExpr = documentFilterExpr;
    }

    public Expression getDocumentFilterExpr() {
        return this.documentFilterExpr;
    }

    public void addFilterDependency(Property property) {
        if (property != this) {
            this.filterDependencies.add(property);
            Property parent = property.getParentProperty();
            if (parent != null) {
                this.addFilterDependency(parent);
            }
            this.addFilterDependencies(property.filterDependencies);
        }
    }

    public void addFilterDependencies(Set<Property> properties) {
        properties.forEach(this::addFilterDependency);
    }

    public boolean filterDependsOn(Property property) {
        return this.filterDependencies.contains(property);
    }

    public boolean hasFilterDependency() {
        return !this.filterDependencies.isEmpty();
    }

    public String getOptionsFingerprint() {
        int fingerprint = 0;
        if (this.stored) {
            fingerprint |= 1;
        }
        if (this.indexed) {
            fingerprint |= 2;
        }
        if (this.analyzed) {
            fingerprint |= 4;
        }
        if (this.multivalued) {
            fingerprint |= 8;
        }
        if (this.facet) {
            fingerprint |= 0x10;
        }
        return fingerprint + MULTIFIELD_SUFFIX_LEGACY + this.nativeType;
    }

    public void finalizeStructures() {
        for (int i = 0; i < this.nextHopIdsAtPositionSets.length; ++i) {
            TLongHashSet nextHopSet = this.nextHopIdsAtPositionSets[i];
            this.nextHopIdsAtPosition[i] = nextHopSet != null ? nextHopSet.toArray() : ArrayUtils.EMPTY_LONG_ARRAY;
        }
        for (Property objectElement : this.object) {
            objectElement.finalizeStructures();
        }
        if (!this.object.isEmpty()) {
            this.object = PropertyUtil.sortPropertiesForFiltering(this.object);
        }
    }

    public Property getParentProperty() {
        return this.parentProperty;
    }

    private String getCanonicalPrefixForChildren() {
        return (this.parentProperty != null ? this.parentProperty.getCanonicalPrefixForChildren() : "") + this.fieldName.fieldNameWithSuffix + ".";
    }

    Set<String> getAllPrefixesForChildren() {
        LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
        Set<String> parentPrefixes = this.parentProperty != null ? this.parentProperty.getAllPrefixesForChildren() : Collections.singleton("");
        for (String parentPrefix : parentPrefixes) {
            prefixes.add(parentPrefix + this.fieldName.fieldNameWithSuffix + ".");
            prefixes.add(parentPrefix + this.fieldName.fieldNameWithoutSuffix + ".");
        }
        return prefixes;
    }

    public String toString() {
        return "Property{field=" + this.fieldName.fullyQualifiedNameWithSuffix + ", filterDependencies=" + String.valueOf(this.filterDependencies) + "}";
    }
}

