/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.config;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.IndexExistValidator;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import com.ontotext.trree.plugin.externalsync.config.validators.ValidatorWithPlugin;
import com.ontotext.trree.sdk.ClientErrorException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class OptionsValidator {
    private final Options optionsToUpdate;

    public OptionsValidator() {
        this(null);
    }

    public OptionsValidator(@Nullable Options optionsToUpdate) {
        this.optionsToUpdate = optionsToUpdate;
    }

    public void validate(ExternalSyncPlugin plugin, Options optionsSet, Iterable<Option<?>> options) {
        for (Option<?> option : options) {
            if (this.optionsToUpdate != null) {
                if (option.isUpdatable() || !optionsSet.hasExplicitValue(option)) continue;
                throw new IllegalArgumentException("Option " + option.getName() + " may not be updated after creation!");
            }
            if ("types".equals(option.getName()) || !option.isRequired() || optionsSet.getValue(option) != null) continue;
            throw new IllegalArgumentException("Option " + option.getName() + " is required!");
        }
        LinkedHashMap<String, Object> errorMessages = new LinkedHashMap<String, Object>();
        boolean hasError = false;
        Options values = optionsSet;
        if (this.optionsToUpdate != null) {
            values = this.optionsToUpdate.copy();
            values.updateOptions(optionsSet, options);
        }
        for (Option<?> option : options) {
            List<Validator<?>> validators;
            if (this.optionsToUpdate != null && !optionsSet.hasExplicitValue(option) || (validators = option.getValidator()).isEmpty()) continue;
            for (Validator<?> validator : validators) {
                Object value = values.getValue(option);
                Object errorMsg = validator instanceof IndexExistValidator ? ((IndexExistValidator)validator).validate(plugin, this.optionsToUpdate, values) : (validator instanceof ValidatorWithPlugin ? ((ValidatorWithPlugin)validator).validate(plugin, value, values) : validator.validate(value, values));
                if (errorMsg == null) continue;
                errorMessages.put(option.getName(), errorMsg);
                hasError = true;
            }
        }
        if (hasError) {
            throw new ClientErrorException(this.mapMessage(errorMessages, 0));
        }
    }

    private String mapMessage(Map<?, ?> errorMessages, int level) {
        return errorMessages.entrySet().stream().map(e -> {
            Object optionMessage = e.getValue();
            if (optionMessage instanceof List) {
                optionMessage = ((List)optionMessage).stream().filter(Objects::nonNull).map(message -> {
                    if (message instanceof Map) {
                        return this.mapMessage((Map)message, level + 1);
                    }
                    return message.toString();
                }).collect(Collectors.joining(", "));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("sub-".repeat(Math.max(0, level)));
            builder.append("option '").append(e.getKey()).append("': ").append(optionMessage);
            if (level == 0) {
                return StringUtils.capitalize((String)builder.toString());
            }
            return builder.toString();
        }).collect(Collectors.joining("; "));
    }
}

