/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.config;

import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.sdk.Entities;
import gnu.trove.TLongHashSet;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OptionsUtil {
    private static ValueFactory VF = SimpleValueFactory.getInstance();

    public static long[] resolveAllEntities(Collection<String> uris, Entities entities) {
        long[] ids = new long[uris.size()];
        int i = 0;
        for (String uri : uris) {
            ids[i++] = entities.put((Value)VF.createIRI(uri), Entities.Scope.DEFAULT);
        }
        return ids;
    }

    public static Map<String, TLongHashSet> resolveAdditionalJoins(Map<String, List<String>> additionalJoins, Entities entities) {
        HashMap<String, TLongHashSet> joins = new HashMap<String, TLongHashSet>(additionalJoins.size());
        for (Map.Entry<String, List<String>> additionalJoinEntry : additionalJoins.entrySet()) {
            String property = additionalJoinEntry.getKey();
            for (String value : additionalJoinEntry.getValue()) {
                long object;
                if ("".equals(value)) {
                    object = 0L;
                } else {
                    IRI objectValue;
                    try {
                        objectValue = VF.createIRI(value);
                    }
                    catch (IllegalArgumentException e) {
                        objectValue = VF.createLiteral(value);
                    }
                    object = entities.put((Value)objectValue, Entities.Scope.DEFAULT);
                }
                if (joins.containsKey(property)) {
                    ((TLongHashSet)joins.get(property)).add(object);
                    continue;
                }
                TLongHashSet values = new TLongHashSet();
                values.add(object);
                joins.put(property, values);
            }
        }
        return joins;
    }

    public static Map<String, Long> resolveAdditionalJoinDefaults(Map<String, String> additionalJoins, Entities entities) {
        HashMap<String, Long> joins = new HashMap<String, Long>(additionalJoins.size());
        for (Map.Entry<String, String> additionalJoinEntry : additionalJoins.entrySet()) {
            long object;
            String fieldName = additionalJoinEntry.getKey();
            String value = additionalJoinEntry.getValue();
            if ("".equals(value)) {
                object = 0L;
            } else {
                IRI objectValue;
                try {
                    objectValue = VF.createIRI(value);
                }
                catch (IllegalArgumentException e) {
                    objectValue = VF.createLiteral(value);
                }
                object = entities.put((Value)objectValue, Entities.Scope.DEFAULT);
            }
            joins.put(fieldName, object);
        }
        return joins;
    }

    public static Map<String, ?> parseJson(@Nullable Object json, Map<String, ?> defaultValue) {
        block6: {
            if (json instanceof Map) {
                return (Map)json;
            }
            if (json instanceof String) {
                try {
                    Object parsedJson = new JSONParser().parse((String)json);
                    if (parsedJson instanceof Map) {
                        return (Map)parsedJson;
                    }
                    break block6;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Not a valid JSON string");
                }
            }
            if (json == null) {
                return defaultValue;
            }
        }
        throw new IllegalArgumentException("Not a JSON object");
    }

    public static Class<?> getValueAsClass(Options options, Option<String> classNameOption) {
        Class<?> klass = null;
        String className = options.getValue(classNameOption);
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            try {
                return OptionsUtil.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new ConnectorUserException("Could not load class: " + className, e);
            }
        }
        return klass;
    }

    public static Object instantiateClassFromOption(Options options, Option<String> classNameOption) {
        Class<?> klass = OptionsUtil.getValueAsClass(options, classNameOption);
        Object instance = null;
        if (klass != null) {
            try {
                instance = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConnectorUserException("Could not instantiate class: " + klass.getName(), e);
            }
        }
        return instance;
    }
}

