/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.logger;

import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginTransactionListener;
import com.ontotext.trree.sdk.StatelessPlugin;
import com.ontotext.trree.sdk.StatementListener;
import com.ontotext.trree.sdk.UpdateInterpreter;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class NotificationsLoggingPlugin
extends PluginBase
implements UpdateInterpreter,
StatelessPlugin,
StatementListener,
PluginTransactionListener {
    public static final String NAMESPACE = "http://www.ontotext.com/notifications-logger#";
    boolean logEvents = false;
    private long idEnable;
    private long idDisable;

    public String getName() {
        return "notifications-logger";
    }

    public void initialize(InitReason reason, PluginConnection pluginConnection) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        this.idEnable = pluginConnection.getEntities().put((Value)vf.createIRI(NAMESPACE, "enable"), Entities.Scope.SYSTEM);
        this.idDisable = pluginConnection.getEntities().put((Value)vf.createIRI(NAMESPACE, "disable"), Entities.Scope.SYSTEM);
    }

    public boolean statementAdded(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        if (this.logEvents && this.getLogger() != null) {
            this.getLogger().info("statementAdded()[{}:{}\t{}:{}\t{}:{}\t{}:{}\ttranasaction:{}\texp:{}", new Object[]{pluginConnection.getEntities().get(subject), subject, pluginConnection.getEntities().get(predicate), predicate, pluginConnection.getEntities().get(object), object, context != 0L ? pluginConnection.getEntities().get(context) : "n/a", context, pluginConnection.getTransactionId(), explicit});
        }
        return false;
    }

    public boolean statementRemoved(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        if (this.logEvents && this.getLogger() != null) {
            this.getLogger().info("statementRemoved()[{}:{}\t{}:{}\t{}:{}\t{}:{}\ttranasaction:{}\texp:{}", new Object[]{pluginConnection.getEntities().get(subject), subject, pluginConnection.getEntities().get(predicate), predicate, pluginConnection.getEntities().get(object), object, context != 0L ? pluginConnection.getEntities().get(context) : "n/a", context, pluginConnection.getTransactionId(), explicit});
        }
        return false;
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        if (this.logEvents && this.getLogger() != null) {
            this.getLogger().info("transactionStarted():{}", (Object)pluginConnection.getTransactionId());
        }
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
        if (this.logEvents && this.getLogger() != null) {
            this.getLogger().info("transactionCompleted():{}", (Object)pluginConnection.getTransactionId());
        }
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        if (this.logEvents && this.getLogger() != null) {
            this.getLogger().info("transactionAborted():{}", (Object)pluginConnection.getTransactionId());
        }
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        if (this.logEvents && this.getLogger() != null) {
            this.getLogger().info("transactionCommit():{}", (Object)pluginConnection.getTransactionId());
        }
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.idEnable, this.idDisable};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (predicate == this.idEnable) {
            this.logEvents = true;
            return true;
        }
        if (predicate == this.idDisable) {
            this.logEvents = false;
            return true;
        }
        return false;
    }
}

