/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.similarity;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.persistence.PersistedConfig;
import com.ontotext.forest.persistence.RepositorySimilarityConfig;
import com.ontotext.forest.similarity.IndexBean;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class SimilarityIndexService {
    public static final String CREATING_STATUS = "CREATING";
    private final Map<String, RepositorySimilarityConfig> similarityConfigMap = new ConcurrentHashMap<String, RepositorySimilarityConfig>();
    @Autowired
    private PersistedConfig persistedConfig;

    private String getOldPersistenceProperty() {
        return "similarity_queries";
    }

    private String getPersistenceProperty() {
        return "repo_similarity_queries";
    }

    @PostConstruct
    public void init() {
        this.migrateIndexesIfNeeded();
        this.removeCreatingIndexes();
    }

    protected void migrateIndexesIfNeeded() {
        Map olderIndexes = this.persistedConfig.getMap(this.getPersistenceProperty(), Map.class);
        if (olderIndexes != null) {
            for (String repo : olderIndexes.keySet()) {
                this.initMapIfNotExist(repo);
                Map repoIndexes = this.persistedConfig.getMapMap(this.getPersistenceProperty(), repo, IndexBean.class);
                for (IndexBean bean : repoIndexes.values()) {
                    this.saveIndex(bean, repo);
                }
            }
            this.persistedConfig.deleteMapEntries(this.getPersistenceProperty());
        }
    }

    public IndexBean getIndex(String name, String repo) {
        IndexBean result;
        RepositorySimilarityConfig repositorySimilarityConfig = this.similarityConfigMap.get(repo);
        if (repositorySimilarityConfig != null) {
            result = (IndexBean)repositorySimilarityConfig.getMap(repo, IndexBean.class).get(name);
        } else {
            result = new IndexBean();
            result.setName(name);
        }
        return result;
    }

    private void initMapIfNotExist(String repo) {
        if (!this.similarityConfigMap.containsKey(repo)) {
            RepositorySimilarityConfig config = new RepositorySimilarityConfig();
            config.initPersistentConfigForRepo(repo);
            this.similarityConfigMap.put(repo, config);
            config.updateMapEntries(repo, IndexBean.class, new HashMap());
        }
    }

    private Map<String, IndexBean> getIndexesMap(String repo) {
        this.initMapIfNotExist(repo);
        return this.similarityConfigMap.get(repo) == null ? new HashMap<String, IndexBean>() : this.similarityConfigMap.get(repo).getMap(repo, IndexBean.class);
    }

    public void saveIndex(IndexBean index, String repo) {
        this.initMapIfNotExist(repo);
        Map<String, IndexBean> indexesMap = this.getIndexesMap(repo);
        indexesMap.put(index.getName(), index);
        this.similarityConfigMap.get(repo).updateMapEntries(repo, IndexBean.class, indexesMap);
    }

    public Collection<IndexBean> getAllIndexesForRepo(String repo) {
        return this.getIndexesMap(repo).values();
    }

    private void removeCreatingIndexes() {
        HashSet<String> repositories = new HashSet<String>(this.similarityConfigMap.keySet());
        for (String repo : repositories) {
            RepositorySimilarityConfig config = this.similarityConfigMap.get(repo);
            Map indexBeansForRepo = config.getMap(repo, IndexBean.class);
            for (IndexBean bean : indexBeansForRepo.values()) {
                if (!CREATING_STATUS.equalsIgnoreCase(bean.getStatus())) continue;
                this.deleteIndex(bean.getName(), repo);
            }
        }
    }

    public void deleteIndex(String name, String repo) {
        Map<String, IndexBean> indexMap = this.getIndexesMap(repo);
        IndexBean indexRemove = indexMap.remove(name);
        if (indexRemove == null) {
            throw new IllegalArgumentException("Index '" + name + "' does not exist!");
        }
        try {
            this.similarityConfigMap.get(repo).deleteMapEntry(repo, IndexBean.class, name);
            if (this.getAllIndexesForRepo(repo).isEmpty()) {
                this.similarityConfigMap.remove(repo);
                RepositorySimilarityConfig.deletePersistentConfigForRepo((String)repo);
            }
        }
        catch (Exception e) {
            throw new GraphDBWorkbenchException("Unable to delete index", (Throwable)e);
        }
    }

    public IndexBean getOldIndex(String indexName) {
        return (IndexBean)this.persistedConfig.getMap(this.getOldPersistenceProperty(), IndexBean.class).get(indexName);
    }
}

