/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.size;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class SizeController
extends AbstractController {
    public SizeController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "HEAD"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolUtil.logRequestParameters(request);
        HashMap<String, String> model = new HashMap<String, String>();
        boolean headersOnly = "HEAD".equals(request.getMethod());
        if (!headersOnly) {
            Repository repository = RepositoryInterceptor.getRepository(request);
            ValueFactory vf = repository.getValueFactory();
            Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
            try (RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);){
                long size = repositoryCon.size(contexts);
                model.put("content", String.valueOf(size));
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
            }
        }
        return new ModelAndView((View)SimpleResponseView.getInstance(), model);
    }
}

