/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.webapp.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.webapp.util.HeaderElement;

public class HttpServerUtil {
    public static String getMIMEType(String contentType) {
        if (contentType == null) {
            return null;
        }
        return HeaderElement.parse(contentType).getValue();
    }

    public static String selectPreferredMIMEType(Iterator<String> mimeTypes, HttpServletRequest request) {
        List<HeaderElement> acceptElements = HttpServerUtil.getHeaderElements(request, "Accept");
        if (acceptElements.isEmpty()) {
            if (mimeTypes.hasNext()) {
                return mimeTypes.next();
            }
            return null;
        }
        String result = null;
        HeaderElement matchingAcceptType = null;
        double highestQuality = 0.0;
        while (mimeTypes.hasNext()) {
            String mimeType = mimeTypes.next();
            HeaderElement acceptType = HttpServerUtil.matchAcceptHeader(mimeType, acceptElements);
            if (acceptType == null) continue;
            double quality = 1.0;
            String qualityStr = acceptType.getParameterValue("q");
            if (qualityStr != null) {
                try {
                    quality = Double.parseDouble(qualityStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (quality > highestQuality) {
                result = mimeType;
                matchingAcceptType = acceptType;
                highestQuality = quality;
                continue;
            }
            if (quality != highestQuality || !HttpServerUtil.isMoreSpecificType(acceptType, matchingAcceptType)) continue;
            result = mimeType;
            matchingAcceptType = acceptType;
        }
        return result;
    }

    private static boolean isMoreSpecificType(HeaderElement leftMimeTypeElem, HeaderElement rightMimeTypeElem) {
        String[] leftMimeType = HttpServerUtil.splitMIMEType(leftMimeTypeElem.getValue());
        String[] rightMimeType = HttpServerUtil.splitMIMEType(rightMimeTypeElem.getValue());
        if (rightMimeType != null) {
            if (rightMimeType[1].equals("*") && !leftMimeType[1].equals("*")) {
                return true;
            }
            return rightMimeType[0].equals("*") && !leftMimeType[0].equals("*");
        }
        return true;
    }

    private static String[] splitMIMEType(String mimeTypeString) {
        int slashIdx = mimeTypeString.indexOf(47);
        if (slashIdx > 0) {
            String type = mimeTypeString.substring(0, slashIdx);
            String subType = mimeTypeString.substring(slashIdx + 1);
            return new String[]{type, subType};
        }
        return null;
    }

    public static List<HeaderElement> getHeaderElements(HttpServletRequest request, String headerName) {
        ArrayList<HeaderElement> elemList = new ArrayList<HeaderElement>(8);
        Enumeration headerValues = request.getHeaders(headerName);
        while (headerValues.hasMoreElements()) {
            String value = (String)headerValues.nextElement();
            List<String> subValues = HttpServerUtil.splitHeaderString(value, ',');
            for (String subValue : subValues) {
                if ((subValue = subValue.trim()).isEmpty()) continue;
                elemList.add(HeaderElement.parse(subValue));
            }
        }
        return elemList;
    }

    public static List<String> splitHeaderString(String s, char splitChar) {
        ArrayList<String> result = new ArrayList<String>(8);
        boolean parsingQuotedString = false;
        int startIdx = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == splitChar && !parsingQuotedString) {
                result.add(s.substring(startIdx, i));
                startIdx = i + 1;
                continue;
            }
            if (c != '\"') continue;
            parsingQuotedString = !parsingQuotedString;
        }
        if (startIdx < s.length()) {
            result.add(s.substring(startIdx));
        }
        return result;
    }

    public static HeaderElement matchAcceptHeader(String mimeTypeSpec, List<HeaderElement> acceptElements) {
        HeaderElement mimeTypeElem = HeaderElement.parse(mimeTypeSpec);
        while (mimeTypeElem != null) {
            for (HeaderElement acceptElem : acceptElements) {
                if (!HttpServerUtil.matchesAcceptHeader(mimeTypeElem, acceptElem)) continue;
                return acceptElem;
            }
            mimeTypeElem = HttpServerUtil.generalizeMIMEType(mimeTypeElem);
        }
        return null;
    }

    private static boolean matchesAcceptHeader(HeaderElement mimeTypeElem, HeaderElement acceptElem) {
        if (!mimeTypeElem.getValue().equals(acceptElem.getValue())) {
            return false;
        }
        if (mimeTypeElem.getParameterCount() > acceptElem.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < mimeTypeElem.getParameterCount(); ++i) {
            if (mimeTypeElem.getParameter(i).equals(acceptElem.getParameter(i))) continue;
            return false;
        }
        return true;
    }

    private static HeaderElement generalizeMIMEType(HeaderElement mimeTypeElem) {
        int parameterCount = mimeTypeElem.getParameterCount();
        if (parameterCount > 0) {
            mimeTypeElem.removeParameter(parameterCount - 1);
        } else {
            String mimeType = mimeTypeElem.getValue();
            int slashIdx = mimeType.indexOf(47);
            if (slashIdx > 0) {
                String type = mimeType.substring(0, slashIdx);
                String subType = mimeType.substring(slashIdx + 1);
                if (!subType.equals("*")) {
                    mimeTypeElem.setValue(type + "/*");
                } else if (!type.equals("*")) {
                    mimeTypeElem.setValue("*/*");
                } else {
                    mimeTypeElem = null;
                }
            } else {
                mimeTypeElem = null;
            }
        }
        return mimeTypeElem;
    }

    public static String getPostDataParameter(Map<String, Object> formData, String name) {
        String result = null;
        try {
            Object param = formData.get(name);
            if (param instanceof String[]) {
                String[] paramArray = (String[])param;
                if (paramArray.length > 0) {
                    result = paramArray[0];
                }
            } else if (param instanceof String) {
                result = (String)param;
            }
            if (result != null) {
                result = result.trim();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isEmpty(String string) {
        boolean result = false;
        if (string == null || string.trim().isEmpty()) {
            result = true;
        }
        return result;
    }

    public static boolean isTrue(String string) {
        boolean result = false;
        if (!HttpServerUtil.isEmpty(string) && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on"))) {
            result = true;
        }
        return result;
    }

    public static boolean isFalse(String string) {
        boolean result = false;
        if (!HttpServerUtil.isEmpty(string) && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off"))) {
            result = true;
        }
        return result;
    }
}

