/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.temporal.aggregation;

import com.github.tkurz.media.ontology.exception.NotAggregatableException;
import com.github.tkurz.media.ontology.function.TemporalFunction;
import com.github.tkurz.media.ontology.type.TemporalEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="temporalIntersection", properties={TemporalEntity.class, TemporalEntity.class}, reference=FunctionDoc.Reference.temporal, description="returns new MediaFragmentURI with temporal fragment ( Max( resource1.start, resource2.start ), Min( resource1.end, resource2.end ) ) if intersection exists, else null.", type=FunctionDoc.Type.extensionAggregate)
public class IntersectionFunction
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#temporalIntersection";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        try {
            if (values.length != 2 || !FunctionHelper.isComparable(values)) {
                return null;
            }
            TemporalEntity[] entities = FunctionHelper.toTemporalEntities(values);
            String box = TemporalFunction.getIntersect((TemporalEntity)entities[0], (TemporalEntity)entities[1]).stringValue();
            if (values[0] instanceof IRI) {
                String uri = FunctionHelper.getCleanURI(values[0]);
                return valueFactory.createIRI(uri + "#" + box);
            }
            return valueFactory.createLiteral(box);
        }
        catch (NotAggregatableException | IllegalArgumentException e) {
            return null;
        }
    }
}

