/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.temporal.aggregation;

import com.github.tkurz.media.ontology.function.TemporalFunction;
import com.github.tkurz.media.ontology.type.TemporalEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="temporalBoundingBox", properties={TemporalEntity.class, TemporalEntity.class}, reference=FunctionDoc.Reference.temporal, description="returns new MediaFragment / MediaFragmentURI with temporal fragment ( Min( p1.start, p2.start ), Max( p1.end, p2.end ) ).", type=FunctionDoc.Type.extensionAggregate)
public class BoundingBoxFunction
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#temporalBoundingBox";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        try {
            if (values.length < 2 || !FunctionHelper.isComparable(values)) {
                return null;
            }
            TemporalEntity[] entities = FunctionHelper.toTemporalEntities(values);
            String box = TemporalFunction.getBoundingBox((TemporalEntity[])entities).stringValue();
            if (values[0] instanceof IRI) {
                String uri = FunctionHelper.getCleanURI(values[0]);
                return valueFactory.createIRI(uri + "#" + box);
            }
            return valueFactory.createLiteral(box);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

