/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.temporal.accessor;

import com.github.tkurz.media.ontology.type.TemporalEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="Duration Accessor", properties={TemporalEntity.class}, reference=FunctionDoc.Reference.temporal, description="returns the duration of an interval, null if there is none.", type=FunctionDoc.Type.accessorFunction)
public class DurationAccessor
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#duration";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        if (values.length != 1) {
            return null;
        }
        try {
            TemporalEntity e = FunctionHelper.toTemporalEntity(values[0]);
            if (e == null) {
                return null;
            }
            return valueFactory.createLiteral(e.getEnd().getValue() - e.getStart().getValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

