/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.spatial.accessor;

import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="SpatialFragment", properties={SpatialEntity.class}, reference=FunctionDoc.Reference.spatial, description="returns a string representation of a spatial fragment.", type=FunctionDoc.Type.accessorFunction)
public class SpatialFragment
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#spatialFragment";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        if (values.length == 1) {
            try {
                return valueFactory.createLiteral(FunctionHelper.toSpatialEntity(values[0]).stringValue());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return null;
            }
        }
        if (values.length == 2) {
            throw new NotImplementedException("Not implemented");
        }
        return null;
    }
}

