/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.spatial.accessor;

import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="Center Accessor", properties={SpatialEntity.class}, reference=FunctionDoc.Reference.spatial, description="returns the center of a BoundingBox of a shape, null if there is none.", type=FunctionDoc.Type.accessorFunction)
public class CenterAccessorFunction
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#center";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        if (values.length != 1) {
            return null;
        }
        try {
            SpatialEntity e = FunctionHelper.toSpatialEntity(values[0]);
            if (e == null) {
                return null;
            }
            return valueFactory.createLiteral(e.getCenter().stringValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

