/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.validators;

import com.ontotext.graphql.parser.argument.optimization.RepoStatistics;
import com.ontotext.graphql.parser.argument.optimization.StatisticsCollector;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Query;
import com.ontotext.soaas.configuration.GraphQlQueryOptions;
import com.ontotext.soaas.plugin.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTotalObjectsCountValidator
implements OperationValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryTotalObjectsCountValidator.class);
    public static final double MIN_ESTIMATE = 0.1;
    private GraphQlQueryOptions options;

    public OperationResponse visit(Query query, ValidationContext context) {
        OperationResponse resp = new OperationResponse();
        if (this.options == null) {
            LOGGER.warn("No instance of the GraphQlQueryOptions has been initialized. Can't estimate the number of returned object for the query. Continue execution. Report to development.");
            return resp;
        }
        RepoStatistics stats = null;
        Object collector = context.getData().get(StatisticsCollector.class.getSimpleName());
        if (collector instanceof StatisticsCollector) {
            StatisticsCollector statisticsCollector = (StatisticsCollector)collector;
            if (!statisticsCollector.isEnabled()) {
                return resp;
            }
            stats = statisticsCollector.collect();
        }
        if (stats == null) {
            LOGGER.warn("Repo statistics have not been collected yet. Can't estimate the number of returned object for the query. Continue execution.");
            return resp;
        }
        double estimate = this.estimateNumOfObjects((Selectable)query, stats);
        if (estimate > (double)this.options.getMaxObjectsReturned()) {
            resp.addErrorMessage("maxObjectsReturned.limit.exceeded", new Object[]{this.options.getMaxObjectsReturned(), estimate});
        }
        return resp;
    }

    public OperationResponse visit(Selection selection, ValidationContext context) {
        return new OperationResponse();
    }

    public OperationResponse visit(CreateMutation mutation, ValidationContext context) {
        return new OperationResponse();
    }

    public OperationResponse visit(UpdateMutation mutation, ValidationContext context) {
        return new OperationResponse();
    }

    public OperationResponse visit(DeleteMutation deleteMutation, ValidationContext context) {
        return new OperationResponse();
    }

    private double estimateNumOfObjects(Selectable query, RepoStatistics stats) {
        double est = this.estimateSingleSelectable(query, stats);
        double selectionsEst = 0.0;
        for (Selectable sel : query.getSelections()) {
            selectionsEst += this.estimateNumOfObjects(sel, stats);
        }
        return est + est * selectionsEst;
    }

    private double estimateSingleSelectable(Selectable query, RepoStatistics stats) {
        double statisticsEstimate;
        if (query.getArguments().getWhere().isPresent()) {
            return 1.0;
        }
        if (query.getArguments().getId().isPresent()) {
            return 1.0;
        }
        if (!query.isComplexType()) {
            return 0.0;
        }
        Long explicitLimit = query.getArguments().getLimit().orElse(Long.MAX_VALUE);
        if (query instanceof Query) {
            statisticsEstimate = stats.forShape(((Query)query).getReturnTypeInstance());
        } else {
            Shape parent = query.getDefinedInType();
            PropertyShape prop = parent.getProperty(query.getName()).orElse(null);
            if (prop == null) {
                return 1.0;
            }
            double entityTypeCount = stats.forShape(parent);
            if (entityTypeCount == 0.0) {
                return 0.0;
            }
            statisticsEstimate = stats.forShapeProp(parent, prop) / entityTypeCount;
        }
        return Math.max(Math.min(explicitLimit.doubleValue(), statisticsEstimate), 0.1);
    }

    @Inject
    public void setGraphQlQueryOptions(GraphQlQueryOptions options) {
        this.options = options;
    }
}

