/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.service;

import com.google.common.collect.ImmutableSet;
import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.Scalars;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.introspection.IntrospectionWithDirectivesSupport;
import graphql.language.AstPrinter;
import graphql.language.Node;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.InputValueWithState;
import graphql.schema.SchemaTransformer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class OntoIntrospectionWithDirectivesSupport {
    private final IntrospectionWithDirectivesSupport.DirectivePredicate directivePredicate;
    private final String typePrefix;
    private static final Set<String> INTROSPECTION_ELEMENTS = ImmutableSet.of((Object)Introspection.__Schema.getName(), (Object)Introspection.__Type.getName(), (Object)Introspection.__Field.getName(), (Object)Introspection.__EnumValue.getName(), (Object)Introspection.__InputValue.getName());

    public OntoIntrospectionWithDirectivesSupport() {
        this(env -> true);
    }

    public OntoIntrospectionWithDirectivesSupport(IntrospectionWithDirectivesSupport.DirectivePredicate directivePredicate) {
        this(directivePredicate, "_");
    }

    public OntoIntrospectionWithDirectivesSupport(IntrospectionWithDirectivesSupport.DirectivePredicate directivePredicate, String typePrefix) {
        this.directivePredicate = (IntrospectionWithDirectivesSupport.DirectivePredicate)Assert.assertNotNull((Object)directivePredicate);
        this.typePrefix = (String)Assert.assertNotNull((Object)typePrefix);
    }

    public GraphQLSchema apply(GraphQLSchema schema) {
        final GraphQLObjectType directiveArgumentType = this.mkDirectiveArgumentType(this.typePrefix + "DirectiveArgument");
        final GraphQLObjectType appliedDirectiveType = this.mkAppliedDirectiveType(this.typePrefix + "AppliedDirective", (GraphQLType)directiveArgumentType);
        GraphQLTypeVisitorStub visitor = new GraphQLTypeVisitorStub(){

            public TraversalControl visitGraphQLObjectType(GraphQLObjectType objectType, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLCodeRegistry.Builder codeRegistry = (GraphQLCodeRegistry.Builder)context.getVarFromParents(GraphQLCodeRegistry.Builder.class);
                if (INTROSPECTION_ELEMENTS.contains(objectType.getName())) {
                    GraphQLObjectType newObjectType = OntoIntrospectionWithDirectivesSupport.this.addAppliedDirectives(objectType, codeRegistry, appliedDirectiveType, directiveArgumentType);
                    return this.changeNode(context, (GraphQLSchemaElement)newObjectType);
                }
                return TraversalControl.CONTINUE;
            }
        };
        schema = SchemaTransformer.transformSchema((GraphQLSchema)schema, (GraphQLTypeVisitor)visitor);
        return this.addDirectiveDefinitionFilter(schema);
    }

    private GraphQLObjectType mkDirectiveArgumentType(String name) {
        return GraphQLObjectType.newObject().name(name).description("Directive arguments can have names and values.  The values are in graphql SDL syntax printed as a string. This type is NOT specified by the graphql specification presently.").field(fld -> fld.name("name").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(fld -> fld.name("value").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).build();
    }

    private GraphQLObjectType mkAppliedDirectiveType(String name, GraphQLType directiveArgumentType) {
        return GraphQLObjectType.newObject().name(name).description("An Applied Directive is an instances of a directive as applied to a schema element. This type is NOT specified by the graphql specification presently.").field(fld -> fld.name("name").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(fld -> fld.name("args").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)directiveArgumentType))))).build();
    }

    private GraphQLArgument mkDirectiveFilterArgument() {
        return new GraphQLArgument.Builder().name("name").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).build();
    }

    private GraphQLSchema addDirectiveDefinitionFilter(GraphQLSchema schema) {
        DataFetcher df = env -> {
            List definedDirectives = env.getGraphQLSchema().getDirectives();
            return this.filterDirectives(schema, true, null, definedDirectives);
        };
        GraphQLCodeRegistry codeRegistry = schema.getCodeRegistry().transform(bld -> bld.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)Introspection.__Schema, (String)"directives"), df));
        return schema.transform(bld -> bld.codeRegistry(codeRegistry));
    }

    private GraphQLObjectType addAppliedDirectives(GraphQLObjectType originalType, GraphQLCodeRegistry.Builder codeRegistry, GraphQLObjectType appliedDirectiveType, GraphQLObjectType directiveArgumentType) {
        GraphQLObjectType objectType = originalType.transform(bld -> bld.field(fld -> fld.name("appliedDirectives").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)appliedDirectiveType)))).argument(this.mkDirectiveFilterArgument())));
        DataFetcher df = env -> {
            Object source = env.getSource();
            GraphQLSchema schema = env.getGraphQLSchema();
            if (source instanceof GraphQLDirectiveContainer) {
                GraphQLDirectiveContainer type = (GraphQLDirectiveContainer)env.getSource();
                List appliedDirectives = DirectivesUtil.toAppliedDirectives((GraphQLDirectiveContainer)type);
                Set<String> requestedNames = this.getRequestedDirectives(env.getArgument("name"));
                return this.filterAppliedDirectives(schema, false, type, this.filterRequestedDirectives(appliedDirectives, requestedNames));
            }
            if (source instanceof GraphQLSchema) {
                List appliedDirectives = DirectivesUtil.toAppliedDirectives((Collection)schema.getSchemaAppliedDirectives(), (Collection)schema.getSchemaDirectives());
                Set<String> requestedNames = this.getRequestedDirectives(env.getArgument("name"));
                return this.filterAppliedDirectives(schema, true, null, this.filterRequestedDirectives(appliedDirectives, requestedNames));
            }
            return Assert.assertShouldNeverHappen((String)"What directive containing element have we not considered? - %s", (Object[])new Object[]{originalType});
        };
        DataFetcher argsDf = env -> {
            GraphQLAppliedDirective directive = (GraphQLAppliedDirective)env.getSource();
            return directive.getArguments().stream().filter(arg -> arg.getArgumentValue().isSet());
        };
        DataFetcher argValueDf = env -> {
            GraphQLAppliedDirectiveArgument argument = (GraphQLAppliedDirectiveArgument)env.getSource();
            InputValueWithState value = argument.getArgumentValue();
            GraphQLContext graphQlContext = env.getGraphQlContext();
            Value literal = ValuesResolver.valueToLiteral((InputValueWithState)value, (GraphQLType)argument.getType(), (GraphQLContext)graphQlContext, (Locale)env.getLocale());
            return AstPrinter.printAst((Node)literal);
        };
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)objectType, (String)"appliedDirectives"), df);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)appliedDirectiveType, (String)"args"), argsDf);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)directiveArgumentType, (String)"value"), argValueDf);
        return objectType;
    }

    private Set<String> getRequestedDirectives(Object name) {
        if (name == null) {
            return Collections.emptySet();
        }
        if (name instanceof String) {
            return Collections.singleton(name.toString());
        }
        if (name instanceof Collection) {
            return ((Collection)name).stream().map(Object::toString).collect(Collectors.toSet());
        }
        return (Set)Assert.assertShouldNeverHappen((String)"What directive directive filtering element have we not considered? - %s", (Object[])new Object[]{name});
    }

    private List<GraphQLAppliedDirective> filterRequestedDirectives(List<GraphQLAppliedDirective> directives, Set<String> requested) {
        if (requested.isEmpty()) {
            return directives;
        }
        return directives.stream().filter(graphQLDirective -> requested.contains(graphQLDirective.getName())).collect(Collectors.toList());
    }

    private List<GraphQLDirective> filterDirectives(GraphQLSchema schema, boolean isDefinedDirective, GraphQLDirectiveContainer container, List<GraphQLDirective> directives) {
        return directives.stream().filter(directive -> {
            IntrospectionWithDirectivesSupport.DirectivePredicateEnvironment env = this.buildDirectivePredicateEnv(schema, isDefinedDirective, container, directive.getName());
            return this.directivePredicate.isDirectiveIncluded(env);
        }).collect(Collectors.toList());
    }

    private List<GraphQLAppliedDirective> filterAppliedDirectives(GraphQLSchema schema, boolean isDefinedDirective, GraphQLDirectiveContainer container, List<GraphQLAppliedDirective> directives) {
        return directives.stream().filter(directive -> {
            IntrospectionWithDirectivesSupport.DirectivePredicateEnvironment env = this.buildDirectivePredicateEnv(schema, isDefinedDirective, container, directive.getName());
            return this.directivePredicate.isDirectiveIncluded(env);
        }).collect(Collectors.toList());
    }

    @NotNull
    private IntrospectionWithDirectivesSupport.DirectivePredicateEnvironment buildDirectivePredicateEnv(final GraphQLSchema schema, final boolean isDefinedDirective, final GraphQLDirectiveContainer container, final String directiveName) {
        return new IntrospectionWithDirectivesSupport.DirectivePredicateEnvironment(){

            public GraphQLDirectiveContainer getDirectiveContainer() {
                return container;
            }

            public boolean isDefinedDirective() {
                return isDefinedDirective;
            }

            public String getDirectiveName() {
                return directiveName;
            }

            public GraphQLSchema getSchema() {
                return schema;
            }
        };
    }
}

