/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.service;

import com.github.jsonldjava.utils.JsonUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.cache.TextFileCacheLoader;
import com.ontotext.soaas.common.exceptions.QueryEvaluationException;
import com.ontotext.soaas.query.service.GraphQlQueryRequest;
import com.ontotext.soaas.query.service.GraphQlRequestHandler;
import com.ontotext.soaas.query.service.RequestConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingRequestHandler
implements GraphQlRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final GraphQlRequestHandler delegate;
    private final Cache<String, String> cache;
    private final boolean sanitizeQuery;
    private final String schemaId;
    private final TextFileCacheLoader loader;

    public CachingRequestHandler(GraphQlRequestHandler delegate, String schemaId) {
        this.delegate = Objects.requireNonNull(delegate, "Delegate should not be null");
        this.schemaId = schemaId;
        this.sanitizeQuery = true;
        this.loader = null;
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).concurrencyLevel(Runtime.getRuntime().availableProcessors()).initialCapacity(50).build();
    }

    public CachingRequestHandler(GraphQlRequestHandler delegate, String schemaId, String cacheConfig, String persistentLocation, boolean sanitizeQuery) {
        this.delegate = Objects.requireNonNull(delegate, "Delegate should not be null");
        this.schemaId = schemaId;
        this.loader = CachingRequestHandler.getLoader(persistentLocation);
        this.sanitizeQuery = sanitizeQuery;
        this.cache = this.loader != null ? CacheBuilder.from((String)cacheConfig).build(CacheLoader.from(arg_0 -> ((TextFileCacheLoader)this.loader).load(arg_0))) : CacheBuilder.from((String)cacheConfig).build();
        this.clearAll();
    }

    private static TextFileCacheLoader getLoader(String persistentLocation) {
        return (persistentLocation = StringUtils.trimToNull((String)persistentLocation)) != null ? new TextFileCacheLoader(Paths.get(persistentLocation, new String[0])) : null;
    }

    public void clearAll() {
        this.cache.cleanUp();
        if (this.loader != null) {
            try {
                this.loader.clearAll();
            }
            catch (IOException ioe) {
                LOGGER.warn("Could not clear persistent cache location", (Throwable)ioe);
            }
        }
    }

    @Override
    public boolean accept(GraphQlQueryRequest queryRequest) {
        return this.delegate.accept(queryRequest);
    }

    @Override
    @NotNull
    public Object handleRequest(GraphQlQueryRequest queryRequest, RequestConfig requestConfig) {
        String key = this.buildCacheKey(queryRequest);
        try {
            return this.cache.get((Object)key, this.callDelegateAndStoreResult(key, queryRequest, requestConfig));
        }
        catch (UncheckedExecutionException | ExecutionException ee) {
            Throwable throwable = ee.getCause();
            if (throwable instanceof QueryEvaluationException) {
                QueryEvaluationException queryEvaluationException = (QueryEvaluationException)throwable;
                throw queryEvaluationException;
            }
            throw new QueryEvaluationException(ee.getCause().getMessage(), ErrorCode.UNHANDLED_RUNTIME);
        }
    }

    private Callable<String> callDelegateAndStoreResult(String name, GraphQlQueryRequest queryRequest, RequestConfig requestConfig) {
        return () -> {
            Object response = this.delegate.handleRequest(queryRequest, requestConfig);
            String responseAsString = this.responseToString(response);
            this.writeToStore(name, responseAsString);
            return responseAsString;
        };
    }

    private String responseToString(Object response) {
        if (response == null) {
            throw new QueryEvaluationException("Request handler delegate returned null", ErrorCode.UNHANDLED_RUNTIME);
        }
        Object object = response;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Collection.class, Map.class}, (Object)object2, n)) {
            case 0 -> {
                String str;
                yield str = (String)object2;
            }
            case 1 -> {
                Collection collection = (Collection)object2;
                yield CachingRequestHandler.responseToJsonString(collection);
            }
            case 2 -> {
                Map map = (Map)object2;
                yield CachingRequestHandler.responseToJsonString(map);
            }
            default -> response.toString();
        };
    }

    private static String responseToJsonString(Object handleRequest) {
        try {
            return JsonUtils.toString((Object)handleRequest);
        }
        catch (IOException ioe) {
            throw new QueryEvaluationException("Could not generate JSON response: " + ioe.getMessage(), ErrorCode.UNHANDLED_RUNTIME);
        }
    }

    private void writeToStore(String name, String responseAsString) {
        if (this.loader != null) {
            try {
                this.loader.write(name, responseAsString);
            }
            catch (IOException ioe) {
                LOGGER.warn("Could not write cache entry due to: {}", (Object)ioe.getMessage());
                LOGGER.trace("Could not write cache entry", (Throwable)ioe);
            }
        }
    }

    private String buildCacheKey(GraphQlQueryRequest queryRequest) {
        byte[] query = this.sanitizeQuery(queryRequest.getQuery());
        String variables = queryRequest.getVariables().map(this::variablesToString).orElse("");
        String operationName = queryRequest.getOperationName().orElse("");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(query);
            messageDigest.update(variables.getBytes(StandardCharsets.UTF_8));
            messageDigest.update(operationName.getBytes(StandardCharsets.UTF_8));
            if (this.schemaId != null) {
                messageDigest.update(this.schemaId.getBytes(StandardCharsets.UTF_8));
            }
            return Hex.encodeHexString((byte[])messageDigest.digest());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new QueryEvaluationException(nsae.getMessage(), ErrorCode.UNHANDLED_RUNTIME);
        }
    }

    private String variablesToString(Map<String, Object> map) {
        try {
            return JsonUtils.toString(map);
        }
        catch (IOException ioe) {
            throw new QueryEvaluationException("Could not serialize query variables as JSON: " + ioe.getMessage(), ErrorCode.UNHANDLED_RUNTIME);
        }
    }

    private byte[] sanitizeQuery(String query) {
        if (!this.sanitizeQuery) {
            return query.getBytes(StandardCharsets.UTF_8);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(query.length());
        boolean insideComment = false;
        boolean toSkip = false;
        for (char c : query.toCharArray()) {
            if (c == '\t' || c == ' ') {
                toSkip = true;
            } else if (c == '\n' || c == '\r') {
                insideComment = false;
                toSkip = true;
            } else if (c == '#') {
                insideComment = true;
                toSkip = true;
            }
            if (insideComment || toSkip) {
                toSkip = false;
                continue;
            }
            if (c > '\u007f') {
                stream.write((byte)(c >> 8 & 0xFF));
                stream.write((byte)(c & 0xFF));
                continue;
            }
            stream.write(c);
        }
        return stream.toByteArray();
    }
}

