/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.apollo;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.licensecheck.GraphQlExtendedFeatures;
import com.ontotext.licensecheck.LicenseCheckUtil;
import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.query.Query;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.query.apollo.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Pair;
import org.jetbrains.annotations.NotNull;

@Order(value=100)
public class FederationQueryPostProcessor
implements OperationPostProcessor {
    public void postProcess(Operation operation, SecurityContext securityContext) {
        SomlSchema schema = operation.getSchema();
        boolean isEntitiesQuery = this.isFederatedQuery(operation);
        if (isEntitiesQuery) {
            LicenseCheckUtil.requireGraphQlExtendedLicense((GraphQlExtendedFeatures[])new GraphQlExtendedFeatures[]{GraphQlExtendedFeatures.GRAPH_QL_FEDERATION});
            Set<Shape> distinctTypes = this.findTypesOfRequestedObjects(operation, schema);
            if (distinctTypes.isEmpty()) {
                operation.getSelections().clear();
                return;
            }
            this.removeUnreachableInlineFragments(operation, distinctTypes);
            this.setRestrictiveQueryReturnType((Query)operation, schema, distinctTypes);
        }
        this.groupInlineFragments((Selectable)operation, schema, isEntitiesQuery);
    }

    private void groupInlineFragments(Selectable selectable, SomlSchema schema, boolean isEntitiesQuery) {
        if (selectable.getSelections() == null || selectable.getSelections().isEmpty()) {
            return;
        }
        LinkedHashMap<Integer, List<Selection>> subSelectionMap = new LinkedHashMap<Integer, List<Selection>>();
        selectable.getSelections().stream().filter(Selectable::isRequestedByUser).forEach(subSel -> {
            int hash = Objects.hash(subSel.getName(), subSel.getAlias(), subSel.getSelections());
            subSelectionMap.computeIfAbsent(hash, key -> new LinkedList()).add((Selection)subSel);
        });
        if (this.atLeastOneGroupShouldBeOptimized(subSelectionMap)) {
            SelectionOrderComparator orderComparator = new SelectionOrderComparator(selectable.getSelections());
            subSelectionMap.values().forEach(selGroup -> {
                Selection sampleSelection;
                if (selGroup.size() < 2) {
                    return;
                }
                Set<Shape> fragments = selGroup.stream().map(Selection::getDefinedInType).collect(Collectors.toSet());
                Shape commonParent = this.getCommonParentForField(fragments, (sampleSelection = (Selection)selGroup.getFirst()).getName(), schema);
                if (commonParent == null) {
                    return;
                }
                Collection commonParentSubtypes = schema.getObjects().getConcreteSubTypes(commonParent.getId());
                if (!isEntitiesQuery && !fragments.containsAll(commonParentSubtypes)) {
                    return;
                }
                this.replaceSelections(selectable, (List<Selection>)selGroup, sampleSelection, commonParent);
            });
            this.permuteSelectablesList(selectable.getSelections());
            selectable.getSelections().sort(orderComparator);
            this.permuteSelectablesList(selectable.getSelections());
        }
        selectable.getSelections().forEach(subSel -> this.groupInlineFragments((Selectable)subSel, schema, isEntitiesQuery));
    }

    private void replaceSelections(Selectable selectable, List<Selection> selGroup, Selection sampleSelection, Shape commonParent) {
        sampleSelection.setDefinedIn(commonParent.getId());
        sampleSelection.setDefinedInType(commonParent);
        selectable.getSelections().removeAll(selGroup);
        selectable.getSelections().add(sampleSelection);
    }

    private boolean atLeastOneGroupShouldBeOptimized(Map<Integer, List<Selection>> subSelectionMap) {
        return subSelectionMap.values().stream().map(List::size).reduce(-1, Integer::max) > 1;
    }

    private Shape getCommonParentForField(Set<Shape> children, String prop, SomlSchema schema) {
        Shape parentOffer = this.getMostRestrictiveCommonParent(children, schema);
        if (prop.equals("id") || prop.equals("__typename")) {
            return parentOffer;
        }
        if (!this.parentContainsField(parentOffer, prop)) {
            return null;
        }
        if (this.isPropOverwrittenInAnyChild(parentOffer, children, prop)) {
            return null;
        }
        return parentOffer;
    }

    private boolean parentContainsField(Shape commonParent, String prop) {
        return prop.equals("__typename") || commonParent.getProperty(prop).isPresent();
    }

    private boolean isPropOverwrittenInAnyChild(Shape commonParent, Set<Shape> childClasses, String prop) {
        PropertyShape parentProp = (PropertyShape)commonParent.getProperty(prop).orElseThrow(RuntimeException::new);
        for (Shape childClass : childClasses) {
            Optional childProp = childClass.getProperty(prop);
            if (!childProp.isPresent() || parentProp.getRdfProperty().equals(((PropertyShape)childProp.get()).getRdfProperty())) continue;
            return true;
        }
        return false;
    }

    private void setRestrictiveQueryReturnType(Query operation, SomlSchema schema, Set<Shape> distinctTypes) {
        Shape parent = this.getMostRestrictiveCommonParent(distinctTypes, schema);
        operation.setReturnType(parent.getId());
        operation.setReturnTypeInstance(parent);
    }

    @NotNull
    private Set<Shape> findTypesOfRequestedObjects(Operation operation, SomlSchema schema) {
        List<Pair<String, String>> idTypePairs = Utils.getIdTypePair(operation.getArguments());
        HashSet<Shape> distinctTypes = new HashSet<Shape>();
        for (Pair<String, String> pair : idTypePairs) {
            String typeName = (String)pair.getSecond();
            Shape shape = (Shape)schema.getObjects().get((Object)schema.getPrefixes().nameToShortIri(typeName));
            if (shape == null) continue;
            distinctTypes.add(shape);
        }
        return distinctTypes;
    }

    private boolean isFederatedQuery(Operation operation) {
        return operation instanceof Query && "_entities".equals(operation.getName());
    }

    private Shape getMostRestrictiveCommonParent(Set<Shape> distinctTypes, SomlSchema schema) {
        if (distinctTypes.size() == 1) {
            return distinctTypes.iterator().next();
        }
        ArrayList hierarchy = new ArrayList(schema.getObjects().getHierarchy(distinctTypes.iterator().next().getId()));
        Collections.reverse(hierarchy);
        for (Shape shape : hierarchy) {
            Collection shapeWithChildren = schema.getObjects().getConcreteSubTypes(shape.getId());
            shapeWithChildren.add(shape);
            if (!shapeWithChildren.containsAll(distinctTypes)) continue;
            return shape;
        }
        return (Shape)schema.getObjects().get((Object)"Object");
    }

    private void removeUnreachableInlineFragments(Operation operation, Set<Shape> distinctTypes) {
        Shapes objects = operation.getSchema().getObjects();
        LinkedHashSet<Shape> typesAndParents = new LinkedHashSet<Shape>(distinctTypes);
        distinctTypes.forEach(shape -> typesAndParents.addAll(objects.getHierarchy(shape.getId())));
        operation.getSelections().removeIf(sel -> !typesAndParents.contains(sel.getDefinedInType()));
    }

    private void permuteSelectablesList(List<Selectable> selectables) {
        List inlineFragmentsSelectablesCopy = selectables.stream().filter(Selectable::isInFragment).sorted(Comparator.comparing(Selectable::getDefinedIn)).collect(Collectors.toList());
        int inlineFragmentIndex = 0;
        for (int index = 0; index < selectables.size(); ++index) {
            Selectable selectable = selectables.get(index);
            if (!selectable.isInFragment()) continue;
            selectables.set(index, (Selectable)inlineFragmentsSelectablesCopy.get(inlineFragmentIndex++));
        }
    }

    private static class SelectionOrderComparator
    implements Comparator<Selectable> {
        Map<String, Integer> order = new HashMap<String, Integer>();

        SelectionOrderComparator(List<Selectable> originalOrder) {
            for (Selectable selection : originalOrder) {
                this.order.putIfAbsent(selection.getName(), this.order.size());
            }
        }

        @Override
        public int compare(Selectable s1, Selectable s2) {
            return Integer.compare(this.order.getOrDefault(s1.getName(), Integer.MAX_VALUE), this.order.getOrDefault(s2.getName(), Integer.MAX_VALUE));
        }
    }
}

