/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.proxies;

import com.ontotext.graphql.responder.EndpointExecution;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.Responder;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.query.monitoring.QueryMeter;
import com.ontotext.soaas.query.monitoring.TimeSample;
import java.util.List;

public class TimeTrackingResponder
implements Responder {
    private final Responder responder;
    private final QueryMeter queryMeter;
    private final String operationName;

    public TimeTrackingResponder(Responder responder, QueryMeter queryMeter, String operationName) {
        this.responder = responder;
        this.queryMeter = queryMeter;
        this.operationName = operationName;
    }

    public boolean isSupported(String format) {
        return this.responder.isSupported(format);
    }

    public <E extends EndpointExecution> List<TransformContext> processRequest(ExecutionRequest<E> executionContext) {
        TimeSample executionTimer = this.queryMeter.startSample();
        List transformContexts = this.responder.processRequest(executionContext);
        this.queryMeter.trackQueryExecution(executionTimer, this.operationName);
        return transformContexts;
    }

    public <E extends EndpointExecution> Object transform(List<TransformContext> transformContexts, ExecutionRequest<E> executionContext, String format) {
        TimeSample executionTimer = this.queryMeter.startSample();
        Object transform = this.responder.transform(transformContexts, executionContext, format);
        this.queryMeter.trackQueryTransforming(executionTimer, this.operationName);
        return transform;
    }
}

