/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import java.io.File;
import org.eclipse.rdf4j.federated.endpoint.EndpointType;
import org.eclipse.rdf4j.federated.endpoint.provider.RepositoryInformation;
import org.eclipse.rdf4j.federated.util.Vocabulary;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Models;

public class NativeRepositoryInformation
extends RepositoryInformation {
    public NativeRepositoryInformation(Model graph, Resource repNode) {
        super(EndpointType.NativeStore);
        this.initialize(graph, repNode);
    }

    public NativeRepositoryInformation(String name, String location) {
        super(new File(location).getName(), name, location, EndpointType.NativeStore);
    }

    protected void initialize(Model graph, Resource repNode) {
        this.setProperty("name", repNode.stringValue());
        this.setWritable(Models.getPropertyLiteral((Model)graph, (Resource)repNode, (IRI)Vocabulary.FEDX.WRITABLE, (Resource[])new Resource[0]).map(Literal::booleanValue).orElse(false));
        String location = Models.getPropertyString((Model)graph, (Resource)repNode, (IRI)Vocabulary.FEDX.REPOSITORY_LOCATION, (Resource[])new Resource[0]).orElse(null);
        this.setProperty("location", location);
        this.setProperty("id", new File(location).getName());
    }
}

