/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.stateless;

import com.ontotext.forest.security.stateless.GDBTokenAuthenticationService;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.OncePerRequestFilter;

public class GDBTokenAuthenticationFilter
extends OncePerRequestFilter {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AuthenticationEntryPoint authenticationEntryPoint;
    private GDBTokenAuthenticationService tokenAuthService;

    @PostConstruct
    public void init() {
        this.tokenAuthService = (GDBTokenAuthenticationService)this.applicationContext.getAutowireCapableBeanFactory().createBean(GDBTokenAuthenticationService.class);
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Authentication authentication = this.tokenAuthService.getAuthentication(request);
            if (authentication != null) {
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (AuthenticationException e) {
            this.authenticationEntryPoint.commence(request, response, e);
        }
    }
}

