/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.rest;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.security.role.RoleToSpring;
import com.ontotext.graphdb.security.Role;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Controller
@RequestMapping(value={"/rest/roles"})
public class RolesReportController {
    public static final String MAPPING = "/rest/roles";
    @Autowired
    private SemanticDataManagement semanticDataManagement;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private FilterSecurityInterceptor filterSecurityInterceptor;

    @Hidden
    @RequestMapping(path={"/mapping"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> getRoleEndpointMapping(@RequestParam String mapping, @RequestParam String method, @RequestParam String role) {
        String repositoryId = this.semanticDataManagement.getCurrentRepositoryOrThrow().getRepositoryID();
        String pattern = this.replacePattern(mapping, repositoryId);
        boolean vote = this.vote(this.createAuthentication((GrantedAuthority)new SimpleGrantedAuthority(role)), pattern, RequestMethod.valueOf((String)method), repositoryId);
        return new ResponseEntity((Object)vote, (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<Map<String, Map<String, Boolean>>> getRolesEndpointMapping() {
        String repositoryId = this.semanticDataManagement.getCurrentRepositoryOrThrow().getRepositoryID();
        HashMap votesMapping = new HashMap();
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        List authorities = Arrays.stream(Role.values()).map(RoleToSpring::toGrantedAuthority).collect(Collectors.toList());
        authorities.add(new SimpleGrantedAuthority(Role.Repo.readForRepo((String)repositoryId)));
        authorities.add(new SimpleGrantedAuthority(Role.Repo.writeForRepo((String)repositoryId)));
        for (RequestMappingInfo requestMappingInfo : requestMappingHandlerMapping.getHandlerMethods().keySet()) {
            for (RequestMethod method : requestMappingInfo.getMethodsCondition().getMethods()) {
                for (String pattern : requestMappingInfo.getPatternsCondition().getPatterns()) {
                    for (GrantedAuthority auth : authorities) {
                        pattern = this.replacePattern(pattern, repositoryId);
                        String endpointMethod = pattern + ":" + String.valueOf(method);
                        if (!votesMapping.containsKey(auth.getAuthority())) {
                            votesMapping.put(auth.getAuthority(), new TreeMap());
                        }
                        boolean vote = this.vote(this.createAuthentication(auth), pattern, method, repositoryId);
                        ((Map)votesMapping.get(auth.getAuthority())).put(endpointMethod, vote);
                    }
                }
            }
        }
        return new ResponseEntity(votesMapping, (HttpStatusCode)HttpStatus.OK);
    }

    private String replacePattern(String pattern, String repositoryID) {
        if (pattern.contains("{repository}")) {
            pattern = pattern.replaceAll("\\{repository\\}", repositoryID);
        }
        if (pattern.contains("{repositoryId}")) {
            pattern = pattern.replaceAll("\\{repositoryId\\}", repositoryID);
        }
        return pattern;
    }

    private boolean vote(Authentication auth, String pattern, RequestMethod method, String repositoryId) {
        FilterInvocation filterInvocation = this.createFilterInvocation(pattern, method, repositoryId);
        LinkedList configAttributes = this.filterSecurityInterceptor.obtainSecurityMetadataSource().getAttributes((Object)filterInvocation);
        if (configAttributes == null) {
            configAttributes = new LinkedList();
        }
        try {
            this.filterSecurityInterceptor.getAccessDecisionManager().decide(auth, (Object)this.createFilterInvocation(pattern, method, repositoryId), configAttributes);
        }
        catch (AccessDeniedException e) {
            return false;
        }
        return true;
    }

    private Authentication createAuthentication(GrantedAuthority grantedAuthority) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(grantedAuthority);
        return new TestingAuthenticationToken((Object)"test", (Object)"test", authorities);
    }

    private FilterInvocation createFilterInvocation(String pattern, RequestMethod method, String repositoryId) {
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setContextPath("");
        httpServletRequest.setRequestURI(pattern);
        httpServletRequest.addHeader("X-GraphDB-Repository", (Object)repositoryId);
        httpServletRequest.setServletPath(pattern);
        httpServletRequest.setMethod(method.toString());
        return new FilterInvocation((ServletRequest)httpServletRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
    }
}

